/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	<errno.h>
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	"netutils.h"
#include	"resolve.h"
#include	"utils.h"

int
name_entry_size(struct hostent * he)
{
char ** q;
int ret;
	ret = 1;
	for ( q = he->h_aliases ; *q ; q ++ , ret ++ );
	return ret;
}

int
addr_entry_size(struct hostent * he)
{
char ** q;
int ret;
	ret = 0;
	for ( q = he->h_addr_list ; *q ; q ++ , ret ++ );
	return ret;
}


HOST_ENTRY *
machine2he_v4(struct hostent * he)
{
HOST_ENTRY * ret;
int i;
char ** q;
	if ( he == 0 )
		return 0;
	ret = new_host_entry(
		name_entry_size(he),
		addr_entry_size(he));
	ret->canonical = ret->names[0] = copy_str(he->h_name);
	for ( i = 1 , q = he->h_aliases ; *q ; q ++ , i ++ )
		ret->names[i] = copy_str(*q);
	ret->names[i] = 0;
	for ( i = 0; i < ret->ips_length ; i ++ ) {
		ret->ips[i].type = HAT_V4;
		ret->ips[i].size = sizeof(int);
		ret->ips[i].d.v4 = ntohl(*(unsigned int*)he->h_addr_list[i]);
	}
	for ( i = 0 ; ret->names[i] ; i ++ )
		if ( strcmp(ret->names[i],"loghost") == 0 )
			ret->flags |= HEF_LOGHOST;
	return ret;
}


