/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/types.h>
#include	<sys/wait.h>
#include	<signal.h>
#include	<errno.h>
#include	"utils.h"

int stab[2];


void
exit_stabilizer(char ch)
{
	write(stab[1],&ch,1);
	close(stab[1]);
}

int
stabilizer()
{
char ch;
int ret;
int id;

	all_signal_mask_posix();
	set_ignore_chld();
	ret = 's';
	for ( ; ; ) {
		pipe(stab);
		id = fork();
		if ( id == 0 ) {
			/* children */
			close(stab[0]);
			return ret;
		}
		close(stab[1]);
	retry:
		if ( read(stab[0],&ch,1) == 1 ) {
			switch ( ch ) {
			case 'e':
				close(stab[0]);
				exit(0);
			default:
				ret = ch;
			}
		}
		else	ret = 'a'; /* abort */
		close(stab[0]);
	}
}
