/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <sys/types.h>
#include <time.h>
#include "memory_debug.h"
#include	"utils.h"

char month_table[12][4] = {
"Jan",
"Feb",
"Mar",
"Apl",
"May",
"Jun",
"Jul",
"Aug",
"Sep",
"Oct",
"Nov",
"Dec"
};

int
get_xltime()
{
	return time(0)-UTC_00_00_00_01_01_2001;
}

char *
get_xltime_str(unsigned int t,int format)
{
time_t tt;
struct tm *time_s;
char ret[20];

	tt = t + UTC_00_00_00_01_01_2001;
	
	switch ( format ) {
	case TFMT_UNIX:
		return copy_str(ctime(&tt));
	case TFMT_W3C_DTF:
		time_s = gmtime(&tt);
		strftime(ret, sizeof(ret), "%Y-%m-%d", time_s);
		return copy_str(ret);
	default:
		return 0;
	}
}
