/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"gbview.h"

void
wf_init_status(GBVIEW_STATUS * e)
{
int i;
char * ptr;
	ptr = (char*)e;
	for ( i = 0 ; i < sizeof(*e) ; i ++ , ptr ++ )
		*ptr = 0;
}


void
wf_free_layer_status(GBVIEW_LAYER_STATUS * ls)
{
GBVIEW_LAYER_STATUS * ls_1;
	for ( ; ls ; ) {
		ls_1 = ls->next;
		d_f_ree(ls->entry_url);
		d_f_ree(ls->target_url);
		d_f_ree(ls);
		ls = ls_1;
	}
}

void
wf_free_status(GBVIEW_STATUS * e)
{
	if ( e->flame_base_unit )
		d_f_ree(e->flame_base_unit);
	free_infolist(e->infolist);
	free_indicate(e->indicate);
	e->infolist = 0;
	e->indicate = 0;
	e->flags = 0;
	wf_free_layer_status(e->layers);
}


void
wf_free_plane(GBVIEW_PLANE * p)
{
	switch ( p->h.type ) {
	case 0:
		break;
	case GPT_REDRAW:
		if ( p->r.plane )
			d_f_ree(p->r.plane);
		p->r.plane = 0;
		break;
	case GPT_ZOOM:
		if ( p->z.index_x )
			d_f_ree(p->z.index_x);
		if ( p->z.index_y )
			d_f_ree(p->z.index_y);
		break;
	default:
		er_panic("wf_free_plane");
	}
}
