/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"xl.h"
#include	"task.h"
#include	"pri_level.h"
#include	"gbview.h"
#include	"v.h"

void
wait_stop_all_and_exit()
{
	wait_stop_all();
	printf("connection closed.\n");
	exit(0);
}

int
_main(int argc,char ** argv)
{
int i;
GBVIEW_FLAME * gf;
GBVIEW_STATUS sts;

printf("GBVIEW %i\n",get_xltime());

	view_init(argc,argv);

	gf = wf_new_gf();
	wf_init_status(&sts);
	sts.flags = SF_RADAR;
	wf_set_status(gf,&sts);

	init_gbview_function(gblisp_top_env0, gblisp_top_env1);
	
	if ( argc < 2 ) {
		printf("too few arguments\n");
		exit(1);
	}

	xl_setup_file_nowait(argc,argv);

	wf_init_status(&sts);
	sts.flags = SF_STATUS;
	sts.status = GVFS_ACTIVE;
	wf_set_status(gf,&sts);

	create_task(wait_stop_all_and_exit,0,PRI_XL_FRONT);
	event_loop();

	return 0;
}
