/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdio.h>
#include	"long_char.h"


extern CODE_TABLE_HEADER * ct_root;


void
print_code_table_header_prototype(CODE_TABLE_HEADER * ct)
{
	printf("extern CODE_TABLE_HEADER ct_%x;\n",ct->lcz);
}


void
print_code_entry_prototype(CODE_TABLE_HEADER * ct)
{
	printf("extern CODE_ENTRY tbl_%x[%i];\n",ct->lcz,ct->len);
}


void
print_code_table_header(CODE_TABLE_HEADER * ct)
{
	printf("CODE_TABLE_HEADER ct_%x = {\n",ct->lcz);
	if ( ct->next )
		printf("\t&ct_%x,\n",ct->next->lcz);
	else	printf("\t0,\n");
	printf("\t0x%x,\n",ct->lcz);
	printf("\t0x%x,\n",ct->mask);
	printf("\t0x%i,\n",ct->len);
	printf("\ttbl_%x\n",ct->lcz);
	printf("};\n\n");
}

void
print_code_entry(CODE_TABLE_HEADER * ct)
{
int i;
CODE_ENTRY * e;
CODE_TABLE_HEADER * ct2;
	printf("CODE_ENTRY tbl_%x[] = {\n",ct->lcz);
	for ( i = 0 ; i < ct->len ; i ++ ) {
		e = &ct->tbl[i];
		ct2 = get_code_table_by_char(e->co->code);
		printf("\t{0x%x,&tbl_%x[0x%x]}",
			e->code,
			ct2->lcz,
			e->co - ct2->tbl);
		if ( i != ct->len - 1 )
			printf(",\n");
		else	printf("\n");
	}
	printf("};\n\n");
}


void
print_code_table()
{
CODE_TABLE_HEADER * ct;
	printf("\n\n");
	printf("#include\t\"long_char.h\"\n\n");

	for ( ct = ct_root ; ct ; ct = ct->next )
		print_code_table_header_prototype(ct);
	for ( ct = ct_root ; ct ; ct = ct->next )
		print_code_entry_prototype(ct);
	if ( ct_root )
		printf("CODE_TABLE_HEADER * ct_root = &ct_%x;\n",ct_root->lcz);
	else	printf("CODE_TABLE_HEADER * ct_root;\n");

	printf("\n");

	for ( ct = ct_root ; ct ; ct = ct->next )
		print_code_table_header(ct);
	for ( ct = ct_root ; ct ; ct = ct->next )
		print_code_entry(ct);
		
	printf("\n\n");
}

