/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "pnt_data.h"
#include <string.h>
#include <math.h>

/* ݥꥴե뤫ɤ߹ */
int ReadPnt(const char *filename, FILE *fp, PNT_DATA *pData, int Flags){
	char szBuff[256];
	KIBAN_FILE_HEADER *pHeader;
	int nReturn;
	PNT_RECORD *pRecord;
	int i;
	char seps[]  = " ,\t\n";
	char *token;

	pHeader = &(pData->header);
	if(!(nReturn = ReadKibanFileHeader(fp, pHeader))==ID_ERR_NOERROR){
		printf("::header error at %s\n", filename);
		return nReturn;
	}
	
	/* 쥳ɤ߹ */
	pData->record = (PNT_RECORD *)malloc(pHeader->record_count*sizeof(PNT_RECORD));
	pRecord = pData->record ;
	
	for(i=0;i<pHeader->record_count;){
		if(!fgets(szBuff,sizeof(szBuff),fp)){
			pHeader->record_count=i;
			printf("::record count error at %s\n", pData->header.file_name);
			return ID_ERR_NOERROR;
		}
		chop(szBuff);
		/* ʬ쥳 */
		token = strtok( szBuff, seps );
		if(token==NULL){
			printf("::record format error at %s\n", pData->header.file_name);
			continue;
		}
		strcpy(pRecord->code,token);
		
		/* ֹ桧9 */
		token = strtok( NULL, seps );
		if(token==NULL){
			printf("::record format error at %s\n", pData->header.file_name);
			continue;
		}
		pRecord->id = atoi(token);
		if(Flags & RKF_ABSOLUTE){
			pRecord->pt.x = atof(token) + pHeader->r.left;
			token = strtok(NULL,seps);
			if(token==NULL){
				printf("::record format error at %s\n", pData->header.file_name);
				continue;
			}
			pRecord->pt.y = atof(token) + pHeader->r.top;
		}
		else{
			pRecord->pt.x = atof(token);
			token = strtok(NULL,seps);
			if(token==NULL){
				printf("::record format error at %s\n", pData->header.file_name);
				continue;
			}
			pRecord->pt.y = atof(token);
		}
		++pRecord;
		++i;
	}
	return ID_ERR_NOERROR;
}

int Pnt2SVG(FILE *fp, PNT_DATA *pPnt, int nType, const char *szFillColor, const char *szStrokeColor){
	double fPntSize = 20;
	PNT_RECORD *pPntRecord = pPnt->record;
	int i;
	for(i=0;i<pPnt->header.record_count; ++i){
		/* Ĥpathб */
		double x = pPntRecord->pt.x;
		double y = pPntRecord->pt.y;
		switch(nType){
			case PNT_TYPE_EKI:
				{
					fprintf(fp, "<path id=\"%s_%d\" style=\"fill:%s;stroke:%s;\" "
						"d=\"M %.1f %.1f L %.1f %.1f L %.1f %.1f L %.1f %.1fz\"/>", 
						pPntRecord->code, pPntRecord->id,
						szFillColor, szStrokeColor,
						x-fPntSize, y-fPntSize, /*  */
						x+fPntSize, y-fPntSize, /*  */
						x+fPntSize, y+fPntSize,	/*  */
						x-fPntSize, y+fPntSize);  /*  */
				}
				break;
			case PNT_TYPE_KIJUNTEN:
				{
					double SQRT3=1.732;
					fprintf(fp, "<path id=\"%s_%d\" style=\"fill:%s;stroke:%s;\" "
						"d=\"M %.1f %.1f L %.1f %.1f L %.1f %.1fz\"/>", 
						pPntRecord->code, pPntRecord->id,
						szFillColor, szStrokeColor,
						x, y-(fPntSize*2)/SQRT3, /*  */
						x-fPntSize, y+fPntSize/SQRT3,  /*  */
						x+fPntSize, y+fPntSize/SQRT3);	/*  */
				}
				break;
		}
		++pPntRecord;
	}
	return ID_ERR_NOERROR;
}

PNT_DATA *malloc_pnt_data(){
	PNT_DATA *pData = (PNT_DATA*)(malloc(sizeof(PNT_DATA)));
	memset(pData,0,sizeof(PNT_DATA));
	return pData;
}


void free_pnt_data(PNT_DATA *pData){
	if(!pData)
		return;
	if(pData->record != NULL){
		free(pData->record);
	}
	free(pData);
}
