/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"
#include	"xlerror.h"
#include	"xl.h"

extern void gc_gb_sexp();
XL_SEXP * xl_ApplyAffen();
int loading_target;

void
init_ApplyAffen(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ApplyAffen"),
		get_func_prim(xl_ApplyAffen,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_ApplyAffen(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * af;
XL_SEXP * m, * v;
XL_SEXP * ret;
REAL1 _m[2][2];
GB_POINT _v;
GB_POINT _pt;
XL_SEXP * pt;
	af = get_el(s,1);
	switch ( list_length(af) ) {
	case -1:
		return list_error(af);
	case 2:
		break;
	default:
		goto type_missmatch;
	}
	m = get_el(af,0);
	if ( list2matrix(&ret,_m,m,s->h.file,s->h.line,"ApplyAffen(1)") < 0 )
		return ret;
	v = get_el(af,1);
	if ( list2vector(&ret,&_v,v,s->h.file,s->h.line,"ApplyAffen(2)") < 0 )
		return ret;
	pt = get_el(s,2);
	if ( list2vector(&ret,&_pt,pt,s->h.file,s->h.line,"ApplyAffen(3)")
				 < 0 )
		return ret;
	_pt = p_add(mp_mul(_m,_pt),_v);
	return List(
		get_floating(_pt.x,0),
		get_floating(_pt.y,0),
		-1);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ApplyAffen"),
		List(n_get_string("type_missmatch"),
			-1));
}
