/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"xlerror.h"
#include	"xl.h"
#include	"svg2gb.h"

XL_SEXP * xl_svg();

void
init_svg(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"svg"),
		get_func_prim(xl_svg,FO_NORMAL,0,1,-1));
}


XL_SEXP *
xl_svg(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * _sf)
{
XL_SEXP *ss;
XL_SYM_FIELD *sf;
int inv_arg;
SVG2GB_CONTEXT *ctx;
XL_SEXP * ret;
void gc_gb_sexp();
XL_SEXP * sym;


	ctx = svg2gb_get_context();
	ctx->root_layer = svg_make_layer(l_string(std_cm,"root"));
	ctx->current_layer = ctx->root_layer;
	
	ss = s;
	for(sf = _sf; sf; sf=sf->next){
		char *n = n_string(std_cm, sf->name);
		char *v = n_string(std_cm, sf->data);
	}


	sym = car(s);
	gc_set_nl(sym,gc_gb_sexp);

	gc_push(0,0,"svg1");
	lock_parse();
	lock_mem();
	gc_delete(s);
	s = cdr(s);
	gc_set_nl(s,gc_gb_sexp);
	unlock_mem();
	unlock_parse();

	ret = 0;
	for( ; get_type(s) == XLT_PAIR; ){

		gc_push(0,0,"svg2");
		ss = car(s);
		ret = eval(env, ss);
		if ( get_type(ret) == XLT_ERROR ) {
			gc_pop(ret,gc_gb_sexp);
			break;
		}
		gc_pop(0,0);
		s = cdr(s);
		gc_pop(s,gc_gb_sexp);
		gc_push(s,gc_gb_sexp,"svg3");
		ret = 0;
	}
	gc_pop(ret,gc_gb_sexp);
	return ret;
	
typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"svg"),
		list(n_get_string("save:type missmatch"),
			get_integer(inv_arg,0),
			0));
}


