/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef SVG_FUNCS__
#define SVG_FUNCS__

SVG_LAYER *svg_make_layer(L_CHAR *id);
void svg_free_layer(SVG_LAYER *layer);

SVG_STYLE *svg_make_style(L_CHAR *name, L_CHAR *value);
void svg_free_style(SVG_STYLE *style);

SVG_TRANSFORM_INFO *svg_make_transform();
void svg_free_transform(SVG_TRANSFORM_INFO *trans);

void svg_add_child_layer(SVG_LAYER *parent, SVG_LAYER *child);
SVG_LAYER *svg_find_layer(SVG_LAYER *src, L_CHAR* id);

SVG_STYLE *svg_str2style(L_CHAR *str);
SVG_TRANSFORM_INFO *svg_str2transform(L_CHAR *str);

L_CHAR *svg_find_style(SVG_STYLE *style, L_CHAR *key);
L_CHAR *svg_find_style_from_layer(SVG_LAYER *layer, L_CHAR *key);

SVG_COLOR str2svg_color(const char *str);

#define SVG_DEFAULT_FILL SVG_RGBA(0, 0, 0, 255)
#define SVG_DEFAULT_STROKE SVG_RGB(0, 0, 0)

SVG_COLOR SVG_RGB(unsigned char r, unsigned char g, unsigned char b);
SVG_COLOR SVG_RGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a);
#endif