/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetAttribute();

void
init_GetAttribute(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetAttribute"),
		get_func_prim(xl_GetAttribute,FO_APPLICATIVE,0,2,3));
}

XL_SEXP *
xl_GetAttribute(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * attr;
XL_SEXP * sym;
XL_SYM_FIELD * sf;
XL_SEXP * ret;
	sym = get_el(s,1);
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		goto type_missmatch;
	}
	if ( list_length(s) == 3 ) {
		attr = get_el(s,2);
		switch ( get_type(attr) ) {
		case XLT_ERROR:
			return attr;
		case XLT_STRING:
			break;
		default:
			goto type_missmatch;
		}
		for ( sf = sym->symbol.field ; sf ; sf = sf->next ) {
			if ( l_strcmp(sf->name,attr->string.data) == 0 )
				return get_string(sf->data);
		}
		return 0;
	}
	else {
		ret = 0;
		for ( sf = sym->symbol.field ; sf ; sf = sf->next ) {
			ret = cons(
				List(	get_symbol(sf->name),
					get_string(sf->data),
					-1),
				ret);
		}
		return ret;
	}
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetAttribute"),
		n_get_string("type missmatch"));
}

