/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
gb_lambda(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * args, * a;
XL_SEXP * arg, * ret;
	args = get_el(s,1);
	switch ( get_type(args) ) {
	case XLT_ERROR:
		return args;
	case XLT_PAIR:
	case XLT_NULL:
		break;
	default:
		goto format_error;
	}
	for ( a = args ; get_type(a) ; a = cdr(a) ) {
		if ( get_type(a) != XLT_PAIR )
			goto format_error;
		arg = car(a);
		switch ( get_type(arg) ) {
		case XLT_ERROR:
			return arg;
		case XLT_SYMBOL:
			break;
		default:
			goto format_error;
		}
	}
	ret = get_sexp(0,XLT_FUNC);
	ret->func.type = FT_LAMBDA;
	ret->func.order = FO_APPLICATIVE;
	ret->func.args_env = 0;
	ret->func.max = 1 + list_length(args);
	ret->func.min = 1 + list_length(args);
	ret->func.prim = 0;
	ret->func.l_params = args;
	ret->func.l_body = cdr(cdr(s));
	return ret;
format_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"lambda"),
		list(	n_get_string("format error in lambda argment"),
			0));
}
