#! /bin/csh

setenv XLHOMEDIR /usr/local/xl-gbs
setenv SERVERPORT 8080

setenv UNAME `uname`
echo $XLHOMEDIR > xlhomedir

echo "Making Directories....."

mkdir $XLHOMEDIR
cp -r xlscript $XLHOMEDIR
cp -r xlconf $XLHOMEDIR
mkdir $XLHOMEDIR/xldocs
mkdir $XLHOMEDIR/xlsys
mkdir $XLHOMEDIR/xlwork
mkdir $XLHOMEDIR/xlwork/lump
mkdir $XLHOMEDIR/xlopt
mkdir $XLHOMEDIR/xlopt/ftfont
mkdir $XLHOMEDIR/xllog
mkdir $XLHOMEDIR/tmp

pushd $XLHOMEDIR/xlscript/bin
chmod 0755 *
popd

cd $XLHOMEDIR/tmp

echo Basic Agent Configulation ....

pushd $XLHOMEDIR/xlconf/std
$XLHOMEDIR/xlscript/bin/replace agent.xl ++XLHOMEDIR++ $XLHOMEDIR
$XLHOMEDIR/xlscript/bin/replace agent.xl ++SERVERPORT++ $SERVERPORT
popd

echo Making .xlrc .....

cp $XLHOMEDIR/xlscript/init/xlrc xlrc
$XLHOMEDIR/xlscript/bin/replace xlrc ++XLHOMEDIR++ $XLHOMEDIR
cp xlrc /.xlrc

echo Making launch script for $UNAME .....


switch ($UNAME)
case SunOS:

    cp ../xlscript/init/launch-xl.$UNAME launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl
    cp launch-xl /etc/rc3.d/S91xl
    chmod 0755 /etc/rc3.d/S91xl


    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

    breaksw
case linux:
     cp ../xlscript/init/launch-xl.$UNAME launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl

    chkconfig --add launch-xl

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

   breaksw
case Darwin:

    cp -r ../xlscript/init/$UNAME d
    $XLHOMEDIR/xlscript/bin/replace d/XLServer ++XLHOMEDIR++ $XLHOMEDIR

    mkdir /Library/StartupItems
    setenv D_ST /Library/StartupItems
    setenv D_TARGET $D_ST/XLServer
    rm -r $D_TARGET
    cp -r d $D_TARGET
    chmod 0755 $D_TARGET/XLServer

    $XLHOMEDIR/xlscript/bin/replace -switch-add2 /etc/hostconfig XLSERVER=-NO- XLSERVER=-YES-

    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index /Library/Fonts /System/Library/Fonts

    breaksw
case FreeBSD:

    cp ../xlscript/init/launch-xl.$UNAME launch-xl
    $XLHOMEDIR/xlscript/bin/replace launch-xl ++XLHOMEDIR++ $XLHOMEDIR

    cp launch-xl /etc/init.d
    chmod 0755 /etc/init.d/launch-xl
    cp launch-xl /usr/local/etc/rc.d/launch-xl
    chmod 0755 /usr/local/etc/rc.d/launch-xl


    echo Making font table for gbview .....

    cd $XLHOMEDIR/xlopt/ftfont
    $XLHOMEDIR/xlscript/bin/ft2index -d `find /usr -name fonts.dir -print`

    breaksw
endsw

cd $XLHOMEDIR
rm -r tmp


echo Successfly Finish Install




