/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	 CYieldRepeater										  CYieldRepeater 
// ===========================================================================

#include "CYieldRepeater.h"
#include "AppConstants.h"

CYieldRepeater * CYieldRepeater::theYCR = 0;


int appBusyLv = 0;

extern Point curMouse;
extern "C" void  SetSleepTime( UInt32 inSleepTime );

#if THREAD_DEBUG
void ThreadDebugMessagePrint();
#endif

CYieldRepeater::CYieldRepeater(SInt32 quantum) : mQuantum(quantum), mNextTicks(0)
{
	theYCR = this;
	StartRepeating();
}

void
CYieldRepeater::SpendTime( const EventRecord& inMacEvent )
{
	if ( sGetMouseEvent ) {
		if ( inMacEvent.what != mouseUp && inMacEvent.what != mouseDown ) {
			sGetMouseEvent--;
			SetSleepTime(0);
			return;
		}
		sGetMouseEvent = 0;
		sGoBack = 0;
		LThread::Yield(sGoBack);
	}
	
	if ( inMacEvent.what != 0 ) {
		SetSleepTime(0);
		return;
	}

	*sExitLoop = false;
	
	// set curMouse
	if ( inMacEvent.what != kHighLevelEvent )
		curMouse = inMacEvent.where;

	// wakeup event_thread if exsits
	extern LThread * event_thread;
	if ( event_thread ) {
		try {
			event_thread->Resume();
		} catch (...) {
			::DebugStr("\pcan't resume event_thread");
		}
		LThread::Yield(event_thread);
		if ( *sExitLoop ) {
			*sExitLoop = false;
			return;
		}
	}
	
	// yield to the other threads
	LThread::GetMainThread()->SetPriority(0);
	if (mQuantum < 0)
	{
		LThread::Yield();
	}
	else
	{
		SetSleepTime(0);
		curTick = TickCount();
		mNextTicks = curTick + mQuantum;
		do
		{
			if ( LThread::CountReadyThreads() == 0 ) {
				if ( appBusyLv == 0 )
					SetSleepTime(1);
				break;
			}
			LThread::Yield();
			if ( *sExitLoop ) {
				*sExitLoop = false;
				break;
			}
			curTick = TickCount();
			// If controled cpu too long time,
			// forcely switched to main thread and come here
			if ( LThread::GetPrevThread() && 
				curTick - LThread::GetPrevThread()->mTick > thTicksHeavyAlert ) {
				printf("!!! Heavy Thread : %s(%.1fsec)\n", LThread::GetPrevThread()->mName);
			}
			if ( LThread::GetPrevThread() == LThread::GetMainThread() ) {
				if ( appBusyLv == 0 )
					SetSleepTime(1);
				break;
			}
		} while (curTick <= mNextTicks);
	}
	LThread::GetMainThread()->SetPriority(5);
#if THREAD_DEBUG
	ThreadDebugMessagePrint();
#endif
}

