//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include	<stdlib.h>
#include	"memory_debug.h"
#include	"v.h"
#include	"CLEMWindow.h"

typedef struct v_open_win_s {
	VWINDOW * ret;
	VERROR * err;
	VDISPLAY * d;
	int x;
	int y;
	int w;
	int h;
} V_OPEN_WIN_S;

int
_v_open_win(V_OPEN_WIN_S * v);

int
_v_open_win(V_OPEN_WIN_S * v)
{
VWINDOW * win;
Boolean cosmos_quit();

VDISPLAY * d;
int x;
int y;
int w;
int h;

	d = v->d;
	x = v->x;
	y = v->y;
	w = v->w;
	h = v->h;

	win = (VWINDOW*)d_alloc(sizeof(*win));
	win->d = d;

	win->w =openDefaultWindow(x, y, w, h, win, cosmos_quit);
	
	win->next = d->win_list;
	d->win_list = win;
	win->obj_list = 0;
	v->err->err1 = E_OK;
	v->ret = win;
	return 0;
}

VWINDOW *
v_open_win(VERROR * err,VDISPLAY * d,int x,int y,int w,int h)
{
V_OPEN_WIN_S v;
	v.err = err;
	v.d = d;
	v.x = x;
	v.y = y+48;
	v.w = w;
	v.h = h;
	v.ret = 0;
	ms_do((int(*)())_v_open_win,&v,"v_open_win");
	return v.ret;
}


typedef struct v_get_window_attributes_s {
	VERROR * err;
	VWINDOW_ATTRIBUTES * attr;
	VWINDOW * win;
} V_GET_WINDOW_ATTRIBUTES_S;

int
_v_get_window_attributes(V_GET_WINDOW_ATTRIBUTES_S * v);

int
_v_get_window_attributes(V_GET_WINDOW_ATTRIBUTES_S * v)
{
	v->win->w->GetCLEMWindowAttributes(v->attr);
	v->err->err1 = E_OK;
	return 0;
}


void
v_get_window_attributes(
	VERROR * err,
	VWINDOW_ATTRIBUTES * attr,
	VWINDOW * win)
{
V_GET_WINDOW_ATTRIBUTES_S v;
	v.err = err;
	v.attr = attr;
	v.win = win;
	ms_do((int(*)())_v_get_window_attributes,&v,"v_get_window_attribute");
}


typedef struct v_clear_window_content_s {
	VERROR * err;
	VWINDOW * win;
} V_CLEAR_WINDOW_CONTENT_S;

int
_v_clear_window_content(V_CLEAR_WINDOW_CONTENT_S *v);


int
_v_clear_window_content(V_CLEAR_WINDOW_CONTENT_S *v)
{
	v->win->w->ClearContent();
	v->err->err1 = E_OK;
	return 0;
}

void
v_clear_window_content(VERROR * err, VWINDOW *win)
{
V_CLEAR_WINDOW_CONTENT_S v;
	v.err = err;
	v.win = win;
	ms_do((int(*)())_v_clear_window_content,&v,"v_clear_window_content");
}

} // extern "C"