/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___M_STREAM_H___
#define ___M_STREAM_H___

#include	<stdio.h>
#include	<fcntl.h>
#include	<Winsock2.h>

typedef struct s_file {
	S_HEADER	h;
	HANDLE hfile;
/*	FILE * std_fd; */
} S_FILE;
/*
typedef struct s_accept {
	S_HEADER	h;
	SOCKET		fid;
} S_ACCEPT;
*/

typedef struct s_terminal {
	S_HEADER	h;
	union stream *	inp;
	union stream *	out;
	int		(*prompt)();
} S_TERMINAL;

typedef struct s_socket {
	S_HEADER	h;
	SOCKET		sock;
	int shutdown_before_close;
} S_SOCKET;
typedef S_SOCKET S_ACCEPT;

typedef struct pipe_read_buf {
        struct pipe_read_buf *  next;
        int                     len;
        int                     ptr;
} PIPE_READ_BUF;

typedef struct s_fpipe {
        S_HEADER        h;
/*        int             fid;*/
        int		        fid_read;
        int		        fid_write;
        int             read_flag;
        int             this_ip_addr;
        int             peer_ip_addr;
        int             flags;
#define FPF_FLUSH       0x00000001
#define FPF_WRITE       0x00000002
        PIPE_READ_BUF * head;
        PIPE_READ_BUF * tail;
} S_FPIPE;

typedef union stream {
	S_HEADER	h;
	S_FILE		file;
	S_ACCEPT	accept;
	S_TERMINAL	terminal;
	S_STRING	str;
	S_SOCKET	socket;
	S_CHAIN		chain;
	S_FPIPE		fpipe;
	S_XLoHTTP	xoh;
	S_XLoHTTP_2	xoh2;
} STREAM;

/*
typedef struct proc_send {
	char	msg[32];
	HANDLE	fid[3];
} PROC_SEND;

typedef struct proc_recv {
	char *	ptr;
	HANDLE	fidp;
	S_TABLE *	tbl;
} PROC_RECV;
*/

/* structures about pass data via process */
typedef struct proc_send_header{
	int size; /* total size of chunk */
	char type; /* type of send data */
}PROC_SEND_HEADER;

typedef struct proc_send_chunk{
	PROC_SEND_HEADER header;
}PROC_SEND_CHUNK;

/* the message written to the stream, after receive the stream by child process.*/
typedef struct proc_send_message{
	PROC_SEND_HEADER header;
	char message_on_receive[1];
}PROC_SEND_MESSAGE;

typedef struct proc_send_file{
	PROC_SEND_HEADER header;
	HANDLE hfile;
	int open_mode;
}PROC_SEND_FILE;

typedef struct proc_send_socket{
	PROC_SEND_HEADER header;
	SOCKET sock;
	int open_mode;
}PROC_SEND_SOCKET;

typedef struct proc_send_fpipe{
	PROC_SEND_HEADER header;
	int fid_read;
	int fid_write;
	int open_mode;
}PROC_SEND_FPIPE;


extern STREAM ** recv_streams;
extern int recv_streams_len;
extern S_TABLE s_file_table;
extern S_TABLE s_accept_table;
extern S_TABLE s_terminal_table;
extern S_TABLE s_socket_table;

#define s_pipe_table s_file_table


STREAM *s_open_file_descripter(HANDLE hfile, int open_mode, BOOL do_lock);
void remove_command_line_ampersand(char *command_line);
void meke_proc_send_event_name(char *ret_event_name, const char *map_name);

void meke_stream_receive_event_name(char *ret_event_name, const char *map_name);
void meke_stream_send_ready_event_name(char *ret_event_name, const char *map_name);

#endif
