/**********************************************************************
 
	Copyright (C) 2003-2005
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "openssl/evp.h"


#define OSSL_RAW 0
#define OSSL_RSA_PUBLICKEY 1
#define OSSL_RSA_PRIVATEKEY 2
#define OSSL_RC4KEY 3

typedef struct oSSL_data {
	int type;
	int len;
	int buff_size;
	unsigned char *data;
	int own_data;
} oSSL_data;


typedef struct oSSL_RC4_key{
	unsigned char *data;
	int len;
#define OSSL_ENCODE_USE 1
#define OSSL_DECODE_USE -1
	int use;
	EVP_CIPHER_CTX ctx;
} oSSL_RC4_key;

typedef struct oSSL_RSA_key{
	RSA *rsa;
	int refcnt;
}oSSL_RSA_key;

struct oSSL_object;
struct oSSL_data;

typedef struct oSSL_method {
	int type;
	void (*free)(struct oSSL_object*);
	struct oSSL_data * (*object2data)(struct oSSL_object * obj, int convert_type);
	struct oSSL_object * (*data2object)(struct oSSL_data * data, int convert_type);
}oSSL_method;

#define MAX_OSSL_OBJECT_TYPE 10

extern oSSL_method *oSSL_types[MAX_OSSL_OBJECT_TYPE];

typedef struct oSSL_object {
	int type;
	oSSL_method *method;
	
	union {
		oSSL_RC4_key rc4_key;
		oSSL_RSA_key rsa_key;
	}obj;
} oSSL_object;

void oSSL_init();
void oSSL_close();

oSSL_object *oSSL_object_new(int type, oSSL_method *method);
void oSSL_object_free(oSSL_object * obj);

oSSL_data *oSSL_data_new(int type, unsigned char *data, int len, int own_data, int buff_size);
void oSSL_data_ensure_buff_size(oSSL_data *data, int size);
void oSSL_data_free(oSSL_data * data);


oSSL_data *oSSL_RSA_decode(oSSL_object * private_key, oSSL_data * data);
oSSL_data *oSSL_RSA_encode(oSSL_object * public_key, oSSL_data * data);
int oSSL_RSA_genkey(oSSL_object ** public_key, oSSL_object ** private_key, int size);

int oSSL_RC4_decode(oSSL_data *decoded, oSSL_object * key, oSSL_data *org);
int oSSL_RC4_encode(oSSL_data *encoded, oSSL_object * key, oSSL_data *org);
oSSL_object *oSSL_RC4_genkey(oSSL_data * key_data);

#define OSSL_DATA_FORMAT_DER 0
#define OSSL_DATA_FORMAT_PEM 1
oSSL_data *oSSL_object2data(oSSL_object * obj, int convert_type);
oSSL_object *oSSL_data2object(oSSL_data * data, int convert_type);

void oSSL_RC4_init();
void oSSL_RSA_init();

#ifndef TRUE 
#define TRUE 1
#endif

#ifndef FALSE 
#define FALSE 0
#endif

#ifndef NULL
#define NULL (0)
#endif

#ifdef GBSSL_TEST
#define d_alloc malloc
#define d_f_ree free
#define SEM void*
#define lock_task(SEM)
#define unlock_task(SEM, str)
#define get_tid() 1

#define LL_OSSL 1;
#define new_lock(lock_level) (0)
#define close_lock(SEM) (0)
#else
#include "memory_debug.h"
#include "task.h"
#include "lock_level.h"
#endif

