/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_BUILTUP_AREA_PFT_H_____
#define GM_BUILTUP_AREA_PFT_H_____

#include "vpf_types.h" 
#include "vpf_container.h"
#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	char *nam;
	char soc[4];
	SHORT tile_id;
	LONG end_id;
}GM_BUILTUP_AREA_PFT_RECORD;

void gm_builtup_area_pft_delete(GM_BUILTUP_AREA_PFT_RECORD *record);
BOOL gm_builtup_area_pft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_builtup_area_pft_get_tileid(const GM_BUILTUP_AREA_PFT_RECORD *record);
LONG gm_builtup_area_pft_get_end_id(const GM_BUILTUP_AREA_PFT_RECORD *record);
void gm_builtup_area_pft_write_information_tag(FILE *fp, GM_BUILTUP_AREA_PFT_RECORD *record);



#endif

