/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___M_STREAM_H___
#define ___M_STREAM_H___

#include	<stdio.h>

#ifdef __cplusplus
typedef	class CServerMaster *	ACCEPT;
typedef	class LTCPEndpoint *		SOCKET;
#else
typedef	void *	ACCEPT;
typedef	void *	SOCKET;
#endif

typedef struct s_file {
	S_HEADER	h;
	int		fid;
} S_FILE;

typedef struct s_accept {
	S_HEADER	h;
	ACCEPT		sm;
} S_ACCEPT;

typedef struct s_terminal {
	S_HEADER	h;
	union stream *	inp;
	union stream *	out;
	int		(*prompt)();
} S_TERMINAL;

typedef struct s_socket {
	S_HEADER		h;
	unsigned char	state;
#define S_STATE_OK			1
#define S_STATE_CLOSED		2
#define S_STATE_DELETED	3
	SOCKET		ep;
} S_SOCKET;


typedef struct pipe_read_buf {
	struct pipe_read_buf *	next;
	int			len;
	int			ptr;
} PIPE_READ_BUF;

typedef struct s_fpipe {
	S_HEADER	h;
	int		fid;
	int		read_flag;
	PIPE_READ_BUF *	head;
	PIPE_READ_BUF * tail;
} S_FPIPE;


#ifdef STREAM_LIB

typedef union stream {
	S_HEADER	h;
	S_FILE		file;
	S_SOCKET	socket;
	S_ACCEPT	accept;
	S_TERMINAL	terminal;
	S_STRING	str;
	S_CHAIN		chain;
	S_FPIPE		fpipe;
	S_XLoHTTP	xoh;
	S_XLoHTTP_2	xoh2;
	S_OSSL		ossl;
} STREAM;

typedef struct proc_send {
	char 		msg[32];
	int		fid[2];
} PROC_SEND;

typedef struct proc_recv {
	char *		ptr;
	int		fidp;
	S_TABLE *	tbl;
} PROC_RECV;

#else

typedef void STREAM;

#endif

extern STREAM ** recv_streams;
extern int recv_streams_len;
extern S_TABLE s_file_table;
extern S_TABLE s_accept_table;
extern S_TABLE s_terminal_table;
extern S_TABLE s_fpipe_table;
#define s_pipe_table s_file_table
extern S_TABLE s_socket_table;

void init_socket_stream();


#endif
