/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <UGWorld.h>

#include "v/v_types.h"
#include "v/v_errors.h"

extern "C" {

#include "task.h"

void v_image_new_m(VImage* img, short w, short h, char depth);
void v_image_free_m(VImage* img);
void v_image_draw_start_m(VImage* img);
void v_image_draw_end_m(VImage* img);
bool v_image_call_lock_m(VImage* img);
void  v_image_call_unlock_m(VImage* img);



void
v_image_new_m(VImage* img, short w, short h, char depth)
{
	img->info = new LGWorld((Rect){0,0,h,w},depth);
	img->buf_32 = 0;
	img->w_border = 0;
}

void
v_image_free_m(VImage* img)
{
	delete img->info;
}

void
v_image_draw_start_m(VImage* img)
{
	PixMapPtr pixmap = *GetGWorldPixMap(img->info->GetMacGWorld());
	if ( ! LockPixels(&pixmap) )
		er_panic("v_image_draw_start memory full");
	switch( pixmap->pixelSize ) {
	case 32:
		img->buf_32 = (long*)GetPixBaseAddr(&pixmap);
		img->w_border = (pixmap->rowBytes&(0x3fff)) >> 2;
		break;
	default:
		er_panic("unknown bit depth");
	}
}

void
v_image_draw_end_m(VImage* img)
{
	UnlockPixels(::GetGWorldPixMap(img->info->GetMacGWorld()));
	img->buf_32 = 0;
}

VImage*
v_image_ref(VImage* img)
{
	extern VImage* _v_image_ref(VImage* img);
	return _v_image_ref(img);
}

VImage*
v_image_unref(VImage* img)
{
	extern VImage* _v_image_unref(VImage* img);
	return _v_image_unref(img);
}

bool
v_image_call_lock_m(VImage* img)
{
	extern bool v_image_lock(VImage *img);
	return v_image_lock(img);
}

void 
v_image_call_unlock_m(VImage* img)
{
	extern void v_image_unlock(VImage *img);
	v_image_unlock(img);
}

} // extern "C"