/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	<stdio.h>
#include	"memory_debug.h"
#include	"machine/msequence.h"
#include	"v.h"

int _v_redraw_text(VTEXT * vt)
{
	HWND hwnd=vt->_h.win->w;
	BOOL bPaint=TRUE;
	HFONT oldfont;
	RECT rect;
	SIZE size;
	COLORREF col;
	HDC hdc=NULL;
	unsigned long mcolor;

	hdc=GetDC(vt->_h.win->w);
	oldfont=SelectObject(ghBufferDC,vt->id);
	
	mcolor = GB2MCOLOR_D(vt->_h.win->d,vt->color);
	col = RGBQUADToCOLORREF(*(RGBQUAD*)&mcolor);
	SetTextColor(ghBufferDC, col); 

	if ( vt->background & C_NULL ) {
		SetBkMode(ghBufferDC,TRANSPARENT);
	}
	else
	{
		mcolor = GB2MCOLOR_D(vt->_h.win->d,vt->background);
		col = RGBQUADToCOLORREF(*(RGBQUAD*)&mcolor);
		SetBkColor(ghBufferDC,col);
		SetBkMode(ghBufferDC,OPAQUE);
	}
	rect.left = vt->st_x;
	rect.top = vt->st_y;
	GetTextExtentPoint32(ghBufferDC,n_string(std_cm,vt->data),vt->length,&size);
	rect.right = vt->st_x + size.cx;
	rect.bottom = vt->st_y + size.cy;

	DrawText(ghBufferDC,n_string(std_cm,vt->data),vt->length, &rect, DT_TOP|DT_LEFT|DT_NOPREFIX);

	SelectObject(ghBufferDC,oldfont);
	ReleaseDC(vt->_h.win->w,hdc);
	return 0;
}
void v_redraw_text(VTEXT * vt)
{
	ms_do(_v_redraw_text, (void *)vt, "v_redraw_text");
}

v_text_handler(VOBJECT *obj,int cmd)
{
	switch ( cmd ) {
	case VE_REDRAW:
		v_redraw_text(&obj->vtext);
		break;
	case VE_BUTTON:
		break;
	default:
		fprintf(stderr,"v_text::unsupport cmd %i\n",cmd);
	}
}

typedef struct v_create_text_s{
	VERROR * err;
	VWINDOW *win;
	unsigned long color;
	unsigned long background;
	int size;
	int dir;
	int	st_x;
	int st_y;
	L_CHAR *data;
	int length;
	VOBJECT *ret;
}V_CREATE_TEXT_S;

extern int fontsize;
int _v_create_text(V_CREATE_TEXT_S *v)
{
	VOBJECT * obj;
	HFONT fid=CreateFont(15, 0, 0, 0, FW_NORMAL,
		FALSE, FALSE, FALSE, DEFAULT_CHARSET, OUT_TT_PRECIS, FALSE,
		DEFAULT_QUALITY, VARIABLE_PITCH|FF_ROMAN,"System");

	obj = d_alloc(sizeof(VTEXT));
	obj->vtext.font_name = 0;
	obj->vtext.id = fid;
	obj->vtext.st_x = v->st_x;
	obj->vtext.st_y = v->st_y;
	obj->vtext.data = d_alloc( (v->length+1)*sizeof(L_CHAR));
	memset(obj->vtext.data, 0, (v->length+1)*sizeof(L_CHAR));
	memcpy(obj->vtext.data, v->data, v->length*sizeof(L_CHAR));
	obj->vtext.length = v->length;
	obj->vtext.color = v->color;
	obj->vtext.background = v->background;
	obj->vtext.size = v->size;
	obj->vtext.dir = v->dir;
	obj->header.type = VT_TEXT;
	obj->header.handler = v_text_handler;
	obj->header.win = v->win;
	obj->header.next = v->win->obj_list;
	v->win->obj_list = obj;
	v->err->err1 = E_OK;
	return (int)obj;
}

VOBJECT *v_create_text(
	VERROR * err,
	VWINDOW *win,
	unsigned long color,
	unsigned long background,
	int size,
	int dir,
	int	st_x,
	int st_y,
	L_CHAR *data,
	int length)
{
	V_CREATE_TEXT_S v;
	v.err = err;
	v.win = win;
	v.color = color;
	v.background = background;
	v.size = size;
	v.dir = dir;
	v.st_x = st_x;
	v.st_y = st_y;
	v.data = data;
	v.length = length;
	v.ret = 0;
	return (VOBJECT *)ms_do(_v_create_text, (void*)&v, "v_create_text");
}

typedef struct v_set_text_s{
	VERROR * err;
	VOBJECT * obj;
	unsigned long color;
	unsigned long background;
	L_CHAR *data;
	int length;
}V_SET_TEXT_S;

int _v_set_text(V_SET_TEXT_S *v)
{
	VERROR * err = v->err;
	VOBJECT * obj = v->obj;
	unsigned long color = v->color;
	unsigned long background = v->background;
	L_CHAR *data = v->data;
	int length = v->length;

	if ( !(color & C_NULL) ) {
		obj->vtext.color = color;
	}
	
	if ( !(background & C_NULL) ) {
		obj->vtext.background = background;
	}

	if ( obj->header.type != VT_TEXT ) {
		err->err1 = E_PARAM;
		err->err2 = 0;
		return 0;
	}
	
	if ( data ) {
		d_f_ree(obj->vtext.data);
		obj->vtext.data = d_alloc(sizeof(L_CHAR)*(length+1));
		memset(obj->vtext.data, 0, sizeof(L_CHAR)*(length+1));
		memcpy(obj->vtext.data, data, sizeof(L_CHAR)*(length));
		obj->vtext.length = length;
	}
	err->err1 = E_OK;
	return 0;
}

int v_set_text(VERROR * err,VOBJECT * obj,unsigned long color, unsigned long background,L_CHAR *data,int length)
{
	V_SET_TEXT_S v;
	v.err = err;
	v.obj = obj;
	v.color = color;
	v.background = background;
	v.data = data;
	v.length = length;
	return ms_do(_v_set_text, (void*)&v, "v_set_text");
}

void v_move_text(VOBJECT * obj,int x,int y)
{
	obj->vtext.st_x = x;
	obj->vtext.st_y = y;
}

typedef struct v_text_minrect_s{
	VRECT * r;
	VOBJECT * obj;
}V_TEXT_MINRECT_S;

int _v_text_minrect(V_TEXT_MINRECT_S *v)
{
	VRECT * r = v->r;
	VTEXT *vt=(VTEXT *)(&(v->obj->vtext));
	RECT rect={vt->st_x,vt->st_y,vt->st_x+10,vt->st_y+10};
	HWND hwnd=v->obj->header.win->w;
	HDC hDC=GetDC(hwnd);
	HFONT old=SelectObject(hDC,vt->id);
	DrawText(ghBufferDC, n_string(std_cm, vt->data),vt->length, &rect, DT_TOP|DT_LEFT|DT_NOPREFIX|DT_CALCRECT);
	SelectObject(hDC,old);
	ReleaseDC(hwnd,hDC);
	r->tl.x=rect.left;
	r->tl.y=rect.top;
	r->br.x=rect.right;
	r->br.y=rect.bottom;
	return 0;
}

int v_text_minrect(VRECT * r,VOBJECT * obj)
{
	V_TEXT_MINRECT_S v;
	v.r = r;
	v.obj = obj;
	return ms_do(_v_text_minrect, (void*)&v, "v_text_minrect");
}
