/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_routine.h"
#include	"gbview.h"
#include	"queue.h"
#include	"radar.h"
#include	"xl.h"
#include	"text_render.h"
#include	"tree_cache.h"

extern SEM style_lock,dm_lock,radar_lock,text_render_lock,tc_lock,obj_lock;

void
gc_view_lock()
{
	gc_queue_lock_high();
	if ( lock_up_test(radar_lock) )
		lock_task(radar_lock);
retry:
	gc_gv_resource_onlock();
	if ( lock_up_test(dm_lock) )
		lock_task(dm_lock);
	if ( gc_gv_resource_clock() < 0 ) {
		if ( lock_up_test(dm_lock) )
			unlock_task(dm_lock,"gc_view_lock");
		goto retry;
	}
	if ( lock_up_test(obj_lock) )
		lock_task(obj_lock);
	if ( lock_up_test(text_render_lock) )
		gc_lock_text_render();
	gc_matrix_lock();
	gc_indicate_lock();
	if ( lock_up_test(style_lock) )
		lock_task(style_lock);
	if ( lock_up_test(tc_lock) )
		lock_task(tc_lock);
	gc_xl_lock();
}

void
gc_view_unlock()
{
	gc_xl_unlock();
	gc_indicate_unlock();
	if ( lock_up_test(tc_lock) )
		unlock_task(tc_lock,"gc_view_unlock");
	if  ( lock_up_test(style_lock) )
		unlock_task(style_lock,"gc_unlock style");
	if ( lock_up_test(obj_lock) )
		unlock_task(obj_lock,"view");
	if ( lock_up_test(dm_lock) )
		unlock_task(dm_lock,"gc_unlock dm");
	gc_gv_resource_unlock();
	if ( lock_up_test(radar_lock) )
		unlock_task(radar_lock,"gc_view_unlock");
	gc_matrix_unlock();
	if ( lock_up_test(text_render_lock) )
		gc_unlock_text_render();
}


void
gc_view()
{
	GC_POSITION;

	gc_lib();

	GC_POSITION;

	gc_setup();

	GC_POSITION;

	gc_gv_resource();

	GC_POSITION;

	gc_indicate();
/*
	gc_htmldb();
*/

	GC_POSITION;

	gc_dm();

	GC_POSITION;

	gc_style();

	GC_POSITION;

	gc_text_render();

	GC_POSITION;

	gc_radar();

	GC_POSITION;

	gc_tree_cache();

	GC_POSITION;

	gc_matrix();
}

