/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"gbview.h"
#include	"avt.h"
#include	"machine/include.h"


extern SEM obj_lock;
int not_time,hit_time;

int cmp_obj_code();

int _free_object(RESOURCE*,OBJ*);
void _free_object_list(RESOURCE*);
int _test_object_avt_func(AVT_NODE * a);
void _test_draw_object(RESOURCE * r);


int
draw_object(
	GBVIEW_FLAME * gf,
	OBJ * o,
	DRAW_WORK * dw)
{
int tt;
int ret;
tt = clock();
	if ( o->h.type >= OT_MAX )
		er_panic("draw_object(1)");
	if ( o->h.type < 0 )
		er_panic("draw_object(2)");
	if ( cross_rect_rect(&o->h.minrect,&dw->draw_rect) == 0 )
		return 0;
	if ( object_table[o->h.type][GBF_DRAW] == 0 )
		er_panic("draw_object(3)");
	ret = (*object_table[o->h.type][GBF_DRAW])
		(gf,o,dw);
	return ret;
}

int
get_point_object(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	OBJ * o,
	GET_POINT_WORK * w)
{
	if ( o->h.type >= OT_MAX )
		er_panic("draw_object(1)");
	if ( o->h.type < 0 )
		er_panic("draw_object(2)");
	if ( object_table[o->h.type][GBF_GET_POINT] == 0 )
		er_panic("draw_object(3)");
	return (*object_table[o->h.type][GBF_GET_POINT])
		(gf,r,o,w);
}


int
_free_object(RESOURCE * r,OBJ * o)
{
AVT_NODE * a1;
	if ( o->h.touch )
		return 0;

	a1 = avt_delete(&r->draw_gb.obj_code_tree,o,cmp_obj_code);
	if ( a1 == 0 )
		er_panic("free_object(0)");
	_delete_rect_tree(&r->draw_gb.obj_rect_tree,o);
	d_f_ree(a1);
	touch_obj_mem(-sizeof(*a1));
	if ( o->h.type >= OT_MAX )
		er_panic("free_object(1)");
	if ( o->h.type < 0 )
		er_panic("free_object(2)");
	if ( object_table[o->h.type][GBF_FREE] == 0 )
		er_panic("free_object(3)");
	return (*object_table[o->h.type][GBF_FREE])(o);
}

void
_free_object_list(RESOURCE * r)
{
OBJ * o;

er_panic("free_object_list_x");
	for ( ; r->draw_gb.obj_code_tree ; ) {
		o = r->draw_gb.obj_code_tree->data;
		_free_object(r,o);
	}
}


int
free_object(RESOURCE * r,OBJ * o)
{
int ret;
	lock_task(obj_lock);
	ret = _free_object(r,o);
	unlock_task(obj_lock,"free_object");
	return ret;
}

void
free_object_list(RESOURCE * r)
{
	lock_task(obj_lock);
	_free_object_list(r);
	unlock_task(obj_lock,"free_object");
}
int
select_object(OBJ * o,SELECT_WORK *sw)
{
	if ( o->h.type >= OT_MAX )
		er_panic("select_object(1)");
	if ( o->h.type < 0 )
		er_panic("select_object(2)");
	if ( object_table[o->h.type][GBF_SELECT] == 0 )
		er_panic("select_object(3)");
	return (*object_table[o->h.type][GBF_SELECT])(o,sw);
}


int
object_list(OBJ * o,XL_SEXP ** ret)
{
	if ( o->h.type >= OT_MAX )
		er_panic("object_list(1)");
	if ( o->h.type < 0 )
		er_panic("object_list(2)");
	if ( object_table[o->h.type][GBF_OLIST] == 0 )
		er_panic("object_list(3)");
	return (*object_table[o->h.type][GBF_OLIST])(o,ret);
}


XL_SEXP *
get_object_header(OBJ * o)
{
	if ( o->h.info_org )
		return List(
			List(get_symbol(l_string(std_cm,"id")),
				get_integer(o->h.code,0),
				-1),
			o->h.info_org,
			-1);
	else	return List(
			List(get_symbol(l_string(std_cm,"id")),
				get_integer(o->h.code,0),
				-1),
			List(get_symbol(l_string(std_cm,"information")),
				-1),
			-1);
}



void
_test_object(void * _obj)
{
OBJ * obj;
	obj = _obj;
	if ( obj->h.type < 0 || obj->h.type > OT_MAX )
		er_panic("_test_object(1)");
	if ( obj->h.flags & (~OF_INFO) )
		er_panic("_test_object(2)");
	if ( obj->h.lod_min == -1 && obj->h.lod_max == -1 )
		return;
	if ( obj->h.lod_min < 0 || obj->h.lod_max < 0 )
		er_panic("_test_object(3)");
	check_mem_header((void*)obj);
}


int
_test_object_avt_func(AVT_NODE * a)
{
	_test_object(a->data);
	return 0;
}

void
_test_draw_object(RESOURCE * r)
{
	avt_trace_from_small(r->draw_gb.obj_code_tree,
		_test_object_avt_func,0);
	test_rect_tree(&r->draw_gb.obj_rect_tree);
}


void
test_draw_object(RESOURCE * r)
{
char * url;
	lock_task(obj_lock);
	url = n_string(std_cm,get_url_str2(&r->h.entry));
	if ( r->h.type == RT_DRAW_GB )
		_test_draw_object(r);
	unlock_task(obj_lock,"test_rect_tree");
}



