/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"memory_debug.h"
#include	"init.h"
#include	"gbview.h"
#include	"gbparam.h"
#include	"xl.h"
#include	"pri_level.h"
#include	"version.h"
#include	"utils.h"
#include	"radar.h"
#include	"gb.h"
#include	"change_endian.h"
#include	"win_flame.h"

void change_task();
void load_structure_task();
void test_gbtask();
void ipc_task();
void exec_read_file_task();

extern VERSION ap_version;

void
gv_set_version()
{
char * buf;
	set_version(&ap_version);

	buf = d_alloc(strlen(ap_version.name) +
		strlen(ap_version.version) + 20
		);

	strcpy(buf,ap_version.name);
	strcpy(&buf[strlen(buf)],"/");
	strcpy(&buf[strlen(buf)],ap_version.version);
	set_setagent_msg(buf);

	d_f_ree(buf);
}

void
view_init(int argc,char ** argv)
{
XL_INTERPRETER * xli;


	init_xl(INI_DONTWAITCHI);
	init_function(
		gblisp_top_env0,
		gblisp_top_env1,
		argc,
		argv);
	int_handler = 0;

	init_gb();
	gv_set_version();

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	check_endian();
	init_win_flame();
	init_gbview();
	init_load_structure();
	init_tree_cache();
	init_ri();
	init_radar();
	init_coordinate_browse();
	dsc_init();

}


void loading_file_task();
XL_SEXP * gv_is_insert_query();

#ifdef NODEFINE
XL_SEXP *
start_gbview()
{
int i;
XL_SEXP * er, * q, * ret;
extern int main_tid;


	ret = 0;
	create_task(change_task,0,PRI_DRAW_EXIT);

	main_tid = get_tid();
/* sethomestatus
	set_opening_state(OS_SETHOME);
*/
	gc_push(0,0,"start_gbview(1)");
	q = n_get_symbol("gv-insert-query");
	set_attribute(q,l_string(std_cm,"type"),
		l_string(std_cm,"direct"));

	er = gv_is_insert_query(gblisp_top_env0,
		List(q,view_param.setup_initial_query,-1),0,q->symbol.field);
	gc_pop(0,0);
/* sethomestatus
	set_opening_state(OS_SETHOME_COMPLETE);
*/
	return ret;
}
#endif

