/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___MP_H___
#define ___MP_H___

#include	"long_char.h"
#include	"utils.h"

#define MP_FILENAME	"mp.xl"

#define MP_UNCACHE	1


#define MAPPING_INTERVAL_UNIT		30
#define MAPPING_PING_INTERVAL_UNIT 	10

#define MP_COUNTER_INTERVAL_UNIT	30
#define MP_COUNTER_MIN_INTERVAL		10

#define MPI_REMOTE_LIFE_TIME_MIN	(2*60)
#define MPI_REMOTE_LIFE_TIME_MAX	(3600)
#define MPI_REMOTE_LIFE_TIME_START	(10*60)
#define MPI_EX_WAIT_LIMIT_MIN		(5*60)
#define MPI_EX_WAIT_LIMIT_MAX		(3600)
#define MPI_EX_WAIT_LIMIT_RATE		50

#define LOOP_CHECK_ROUTING_INTERVAL	(24*3600)
#define LOOP_CHECK_ROUTING_INTERVAL_MIN	(10)

#define MAPPING_INTERVAL_AVG		3600

#define INVALID_PRI_TIMEOUT		(3600)
#define CLEAN_INVALID_PRI_INTERVAL	(10*60)

#define MP_LIVE_MAX			(3*24*3600)
#define MP_IDLE_MAX			10

#define MP_TASK_HANGUP_LIMIT		(1800*4)

#define MAPPING_IDLE_CHECK_INTERVAL	600


#define LUMP_MAX			5
#define LUMP_DESTROY_MIN		11
#define LUMP_DESTROY_MAX		120
#define LUMP_LAUNCH_MIN			11
#define LUMP_LAUNCH_MAX			120
#define LUMP_DELAY			60

#define FADE_INTERVAL_MIN		11
#define FADE_INTERVAL_MAX		1000

#define LOOP_LOCK_TOLERANCE		2
#define LOOP_LOCK_COUNT			5
#define LOOP_LOCK_TIMEOUT		120

#define CINDEX_MIN_INTERVAL		60


typedef struct mp_work {
	unsigned int	total_maps;
	unsigned int	total_map_references;
	unsigned int	interval_avg;

	unsigned int	lump_id;

	unsigned int	loop_lock_max;

	unsigned int	c_min_interval;
} MP_WORK;


void
get_mp_work(MP_WORK * w,int type);
void
set_mp_work(MP_WORK * w);


#endif

