/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_BACK_COLOR_VIEW_H___
#define ___V_BACK_COLOR_VIEW_H___

#include "v/VObject.h"


class VBackColorView : public VObject
{
  public:
	enum { object_type = VO_BGCV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 1; }
	
	static VBackColorView*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VBackColorView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VBackColorView*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	virtual void	value_changed(short modkey) {
			if (sts.value_event_handler)
				vq_insert_callback(this,sts.value_event_handler,sts.value_eh_arg,
									&modkey,sizeof(short));
		};
  protected:
	virtual ~VBackColorView();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	virtual VExError add_child_do(VObject* child);
	virtual void	remove_child_do(VObject* child);

  private:
	static VObject *internal_new(){
		return new VBackColorView();
	}
};

#endif
