/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"lc_encode.h"
#include	"tr_html.h"

XL_SEXP * html_a();

void
init_html_a(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"A"),
		get_func_prim(html_a,FO_NORMAL,0,1,-1));
}

XL_SEXP *
html_a(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * _href;
TR_HTML_INFO * inf;
XL_SEXP * ret;
	inf = tr_get_html_info(env);
	_href = get_sf_attribute(sf,l_string(std_cm,"HREF"));
	tr_push_attr_stack(inf);
	_tr_set_attr_reference(
			inf->d.sq,
			&inf->d.attr_stack->attr,_href);
	ret = tr_html_pair_non_symbol(inf,cdr(s));
	tr_pop_attr_stack(inf);
	return ret;
}


