/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"pdb.h"
#include	"favt.h"

void
favt_floating_endian(FLOATING_INDEX * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_f(ix->d);
}

void
favt_gb_time_endian(GB_TIME_INDEX * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_gb_time(&ix->d);
}


void
favt_string_endian(STRING_INDEX * ix,int len)
{
int i;
	change_endian_i(ix->fofs);
	len = (len - sizeof(ix->fofs))/sizeof(L_CHAR);
	for ( i = 0 ; i < len ; i ++ ) {
		change_endian_i(ix->d[i]);
	}
}

void
favt_timeout_endian(TIMEOUT_INDEX * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_i(ix->timeout);
}



void
change_endian_favt_root(PN_FAVT_ROOT * r)
{
	change_endian_header(&r->h);
	change_endian_i(r->type);
	change_endian_i(r->node);
}

void
change_endian_favt_node(PN_FAVT_NODE * n)
{
	change_endian_header(&n->h);
	change_endian_i(n->small);
	change_endian_i(n->large);
	change_endian_i(n->level);
}

void (*change_endian_favt_table_to_host[])() = {
	0,
	change_endian_favt_root,
	change_endian_favt_node
};
