/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___K2M_H__
#define ___K2M_H__

#include	"matrix.h"

#ifdef  __cplusplus
extern "C"{
#endif


MATRIX* matrix_open_kiban(char * filename,INTEGER64 x,INTEGER64 y);
unsigned char * k_ix(void * v,int x,int y);
void write_pixel(INTEGER64 * src,unsigned char * d);
void flush_write_pixel();

typedef void (*onCompleteMapData)(unsigned char *data, int width, int height, double longitude, double latitude, void *userData);

int kokudo_loader_init(
	const char *initfile, 
	double *dotPerDegree,
	double *minLongitude,
	double *minLatitude,
	double *maxLongitude,
	double *maxLatitude);
	
int kokudo_loader_load(
	const char *mapsfile,
	double dotPerDegree,
	onCompleteMapData cb,
	void *userData
	);




#ifdef  __cplusplus
}
#endif


#endif

