/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#include	"stream.h"
#include	"task.h"
#include	"utils.h"
#include	"pri_level.h"


extern SEM stream_lock;

void
s_set_cr(STREAM * s,int cnt)
{
int pri;
	pri = push_pri(PRI_NETWORK);
	lock_task(stream_lock);
	if ( s == 0 )
		goto end;
	if ( s->h.check_ptr != &s->h )
		goto end;
	if ( s->h.tbl == 0 )
		goto end;
	s->h.cr_mode = CRM_COUNT;
	s->h.cr_cnt = cnt;
end:
	unlock_task(stream_lock,"s_set_cr");
	change_pri(0,pri);
}

