/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	"ex_matrix.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_Mzero();

void
init_Mzero(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Mzero"),
		get_func_prim(xl_Mzero,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_Mzero(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
EX_MATRIX * ret;
XL_SEXP * _ret;
int h,v;
L_CHAR * _h, * _v;

	_h = get_sf_attribute(sf,l_string(std_cm,"h"));
	if ( _h == 0 )
		h = 1;
	else {
		h = atoi(n_string(std_cm,_h));
		if ( h <= 0 )
			h = 1;
	}
	_v = get_sf_attribute(sf,l_string(std_cm,"v"));
	if ( _v == 0 )
		v = 1;
	else {
		v = atoi(n_string(std_cm,_v));
		if ( v <= 0 )
			v = 1;
	}
	ret = new_ex_matrix(v,h);
	_ret = get_sexp_from_ex(ret);
	free_ex_matrix(ret);
	return _ret;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Mzero"),
		n_get_string("type missmatch"));
*/
}

