/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xlerror.h"
#include	"xl.h"
#include	"xl_server.h"
#include	"XLoHTTP.h"

XL_SEXP * xl_HttpAgent();

void
init_HttpAgent(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"HttpAgent"),
		get_func_prim(xl_HttpAgent,FO_NORMAL,0,1,-1));
}

XL_SEXP *
xl_HttpAgent(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * ae,XL_SYM_FIELD * sf)
{
L_CHAR * remote, * path;
XL_SEXP * ret;
HTTP_AGENT_LIST * a;
	remote = get_sf_attribute(sf,
			l_string(std_cm,"remote"));
	path = get_sf_attribute(sf,
			l_string(std_cm,"path"));
	if ( path == 0 )
		goto path_required;
	if ( remote == 0 ) {
		s = cdr(s);
		for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
			ret = eval(e,car(s));
			if ( get_type(ret) == XLT_ERROR )
				return ret;
		}
		insert_http_agent_list(
			n_string(std_cm,path),
			e,0,0);
	}
	else {
		a = insert_http_agent_list(
			n_string(std_cm,path),
			e,
			remote,
			cdr(s));
		initialize_remote(a);
		if ( a->iid < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"HttpAgent"),
				List(n_get_string(
					"cannot initialize remote"),
					get_integer(a->iid,0),
					-1));
	}
	return 0;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetAgent"),
		0);
*/
path_required:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"HttpAgent"),
		n_get_string("path attribute"));
}

