/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_REFLECTOR_H___
#define ___V_REFLECTOR_H___

#include <LListener.h>
#include "v/VObject.h"

class VReflector : public LListener
{
public:
	VReflector(VObject *object)
	{
		mObject = object;
	}
	
	virtual void ListenToMessage(MessageT inMessage, void* ioParam)
	{
		switch ( inMessage ) {
		  case msg_ValueChanged:
			mObject->value_changed();
			break;
			
		  case msg_DescriptorChanged:
			mObject->descriptor_changed();
			break;
			
		  case msg_BroadcasterDied:
			delete this;
			break;
		}
	}

protected:
	VObject *	mObject;
};


#endif // ___V_REFLECTOR_H___
