/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_M_H___
#define ___V_M_H___

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif
	
#include "thread.h"
	
#ifdef __cplusplus
}
#endif


#define ENABLE_SERIALIZER


// MACHINE COMMON CONSTANTS & MACROS



typedef GtkWidget VInfo;
typedef GdkPixbuf* VImageInfo;
typedef GSList* VRadioGroupInfo;
typedef GtkTreeIter VTreeNodeInfo;
#ifdef __cplusplus
class VWindow;
#else
typedef void VWindow;
#endif
typedef struct {
	GtkMenuItem*	widget;
	GtkWindow *		window;
	void *				work;
} VMenuItemInfo;


#define V_DEFAULT_SPACING	8
#define V_DEFAULT_PADDING	0
#define V_DEFAULT_FSIZE		100
#define V_WINDOW_MIN_WIDTH	100
#define V_WINDOW_MIN_HEIGHT	50

#define _V_OP_START(err) {	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		return err;	\
	}	\
}

#define _V_OP_START_VOID {	\
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
		unlock(this);	\
		return;	\
	}	\
}

#define V_OP_START _V_OP_START(V_ER_DESTROYED)



#define _V_OP_START_EX(c) \
	lock(this,__FILE__,__LINE__);	\
	if ( destroy_time != V_OBJECT_ALIVE ) {	\
	VExError er;				\
		er.code = c;			\
		er.subcode1 = 0;			\
		unlock(this);	\
		return er;		\
	}

#define V_OP_START_EX _V_OP_START_EX(V_ER_DESTROYED)

#define V_OP_END {	\
	unlock(this);	\
}

#ifdef __cplusplus
extern "C" void exec_in_gtk_main(void(*func)(void*), void *arg);
#define V_SERIALIZED_EXEC(func, arg)  exec_in_gtk_main((void(*)(void*))func, arg)
#endif


enum VdataType {
	VDT_NONE	= 0,
	VDT_STRING		= 'S',
	VDT_L_STRING	= 'L',
	VDT_IMAGE		= 'I'
};


// MACHINE DEPENDENT CONSTANTS


#define VIA_MS_G_SIGNAL_CONNECT(widget,event,callback,data)	\
v_serialized_exec_func(g_signal_connect_data,	\
		widget, event, G_CALLBACK(callback), data, GClosureNotify(0), (GConnectFlags)0);


#define SET_RGB8_32(pix,r,g,b,a) do {     \
	((unsigned char*)(&pix))[0] = (r); \
	((unsigned char*)(&pix))[1] = (g); \
	((unsigned char*)(&pix))[2] = (b); \
	((unsigned char*)(&pix))[3] = (a); \
} while(0)
#define GET_RGB8_32(pix,r,g,b,a) do {	  \
	r = ((unsigned char*)(&pix))[0]; \
	g = ((unsigned char*)(&pix))[1]; \
	b = ((unsigned char*)(&pix))[2]; \
	a = ((unsigned char*)(&pix))[3]; \
} while(0)
#define IS_RGB8_32(pix,r,g,b,a)                \
	(((unsigned char*)(&pix))[0] == (r) && \
	 ((unsigned char*)(&pix))[1] == (g) && \
	 ((unsigned char*)(&pix))[2] == (b) && \
	 ((unsigned char*)(&pix))[3] == (a) )

#define RGB8_MAX	255



// MACHINE DEPENDENT CONSTANTS & PROTOTYPES

#ifdef __cplusplus

const int SPLIT_BAR_WIDTH = 5;

extern "C" {
#endif

#include "long_char.h"

void value_changed(GtkWidget *w, gpointer c);
void descriptor_changed(GtkWidget *w, gpointer c);

char * ucd_n_string(const L_CHAR *lc);
void _set_styled_descriptor_style(VInfo * info, char * font, int is_bin);
char * _set_styled_descriptor_get_font(const L_CHAR * descriptor,
	const LC_WRITING_STYLE * ws, int fsize);
void set_styled_descriptor(const L_CHAR * descriptor,
	const LC_WRITING_STYLE * ws, int fsize,
	int vert_desc, VInfo * info, int is_bin);

void set_suspend_gtk_main(int suspend);

#ifdef __cplusplus
}
#endif

#endif
