/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VButton.h"
#include "machine/v_object.h"

extern "C" {
void add_shortcut_key(GtkWidget *window, GtkWidget *widget, int type);
void remove_shortcut_key(GtkWidget *window, GtkWidget *widget, int type);
}

extern "C" gboolean
v_push_button_grab_default(GtkWidget *widget,
	gpointer event,
	gpointer user_data)
{
	gtk_widget_grab_default(widget);
	if ( user_data && GTK_WIDGET_MAPPED(widget) )
		gtk_widget_grab_focus(widget);
	return FALSE;
}

void
v_push_button_set_shortcut(VInfo *win, VInfo *info, int type, bool add)
{
	if ( type == 1 ) {
		 if ( add ) {
			GTK_WIDGET_SET_FLAGS(info, GTK_CAN_DEFAULT);
			g_signal_connect(info, "map",
				G_CALLBACK(v_push_button_grab_default), 0);
		}
		else {
			GTK_WIDGET_UNSET_FLAGS(info, GTK_CAN_DEFAULT);
			g_signal_handlers_disconnect_by_func(info, 
				(void*)v_push_button_grab_default, 0);
		}
	}
	if ( add )
		add_shortcut_key(win, info, type);
	else
		remove_shortcut_key(win, info, type);
}


VExError
VPushButton::create_do(const VObjectStatus* s, int flags, 
		VObject * nmp,void * arg)
{
	info = v_serialized_exec_func(gtk_button_new_with_label, "");
	VIA_MS_G_SIGNAL_CONNECT(info, "clicked", ::value_changed, this);
	v_serialized_exec_sub(g_object_ref, info);
	VExError er = return_create_do(this,nmp,&sts,s,flags);
	if ( (flags & VSF_ATTR) && (s->attr & default_button) )
		v_serialized_exec_sub(v_push_button_grab_default, info, (gpointer)0, (gpointer)1);
	return er;
}

void
VPushButton::destroy_do(VObject * nmp)
{
	if ( sts.attr & default_button )
		v_serialized_exec_sub(remove_shortcut_key, 
			sts.window->get_info_this(), info, 1);
	if ( sts.attr & cancel_button )
		v_serialized_exec_sub(remove_shortcut_key, 
			sts.window->get_info_this(), info, 2);
	return VButton::destroy_do(nmp);
}

VPushButton::~VPushButton()
{
}

VExError
VPushButton::get_status(VObjectStatus *s, int flags) const
{
	return VButton::get_status(s,flags);
}

VExError
VPushButton::set_status(const VObjectStatus *s, int flags)
{
	if ( flags & VSF_ATTR ) {
		v_serialized_exec_sub(v_push_button_set_shortcut, 
			sts.window->get_info_this(), info,
			1, (s->attr & default_button) != 0);
		v_serialized_exec_sub(v_push_button_set_shortcut, 
			sts.window->get_info_this(), info,
			2, (s->attr & cancel_button) != 0);
	}
	return  VButton::set_status(s,flags);
}
