/**********************************************************************
 
	Copyright (C) 2004 Tomohito Nakajima <nakajima@zeta.co.jp>
	
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/*
windows server debug utility
*/

#ifndef LOGGER_____
#define LOGGER_____

/* logger compile time config */
#define LOGGER_MULTI_PROCESS
#define LOGGER_MULTI_THREAD
#define logger_assert(exp) assert(exp)
#define logger_get_tick() GetTickCount()
/* end of config */


#ifdef __cplusplus
extern "C"{
#else
#endif

enum {
	LOGGER_FORMAT_DATE=1,
	LOGGER_FORMAT_DATETIME=2,
	LOGGER_FORMAT_TICK=4,
	LOGGER_FORMAT_WITHLF=8,
	LOGGER_FORMAT_SEQUENCE=16,
	LOGGER_FORMAT_THREADID=32,
	LOGGER_FORMAT_PROCESSID=64,
	LOGGER_FORMAT_APPNAME=128,
	LOGGER_FORMAT_FULLAPPNAME=256,
};
typedef int LoggerFormat;

typedef void* LoggerHandle;

LoggerHandle logger_open(const char *filename, const char*name, LoggerFormat format);
void logger_write(LoggerHandle handle, const char *fmt, ...);
void logger_close(LoggerHandle handle);
void logger_write_caption(LoggerHandle handle);

#ifdef __cplusplus
} // end of extern "C"
#endif

#ifdef __cplusplus
// if from c++ source, use this logger class. 
class Logger
{
	LoggerHandle handle;
public:
	Logger(const char *filename, const char*name=0, 
		LoggerFormat format=LOGGER_FORMAT_DATETIME|LOGGER_FORMAT_WITHLF)
	{
		handle = logger_open(filename, name, format);
	};
	void write_caption(){
		logger_write_caption(handle);
	}
	void write(const char *fmt, ...);
	~Logger(){logger_close(handle);}
};
#endif

#endif
