/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VDisplay.h"
#include "v/VWindow.h"

VDisplay* VDisplay::main_display = 0;

VDisplay*
VDisplay::create()
{
	// VDisplay does not have parent
	VDisplay* ret = new VDisplay;
	ret->create_do(0,0,0,0);
	return ret;
}

VExError
VDisplay::create_do(const VObjectStatus *, int flags, VObject *parent,  void *arg)
{
	sts.parent = 0;
	if ( main_display )
		er_panic("multiple display construction");
	main_display = this;
	set_status(&v_default_sts, VSF_ALL_FLAGS);
	info = NULL;
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VDisplay::destroy_do(VObject *)
{
	main_display = 0;
}

VDisplay::~VDisplay()
{
}

/*
const needs
VError
VDisplay::accept_child_ex(long type, VObject *obj)
{
	if ( type != VWindow::object_type )
		return V_ER_PARAM;
	return V_ER_NO_ERR;
}
*/
VError
VDisplay::accept_child_ex(long type, VObject *obj) const
{
	if ( type != VWindow::object_type )
		return V_ER_PARAM;
	return V_ER_NO_ERR;
}
