/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"gbview.h"
#include	"rs_cache.h"

int close_default(RESOURCE * r);


void
new_resource_option()
{
	assert_ls_all(LSF_ASSERT);
}

int
browse_resource(RESOURCE * r,BROWSE_WORK * bw)
{
int ret;
	if ( r->h.type >= RT_MAX )
		er_panic("browse_resource(1)");
	if ( r->h.type < 0 )
		er_panic("browse_resource(2)");
	if ( resource_table[r->h.type][GBF_BROWSE] == 0 )
		er_panic("draw_resource_task(3)");

//printf("br %s\n",n_string(std_cm,get_url_str2(&r->h.target)));

	ret = (*resource_table[r->h.type][GBF_BROWSE])(r,bw);

//printf("br %s end\n",n_string(std_cm,get_url_str2(&r->h.target)));

	return ret;
}

/*
int
equ_d(REAL1 x,REAL1 y)
{
	if ( x - y > 0.1 )
		return -1;
	if ( x - y < -0.1 )
		return -1;
	return 0;
}

void
print_draw(RESOURCE * r,DRAW_WORK * dw)
{

	if ( equ_d(dw->pt_list[dw->size/2].x,300) ||
			equ_d(dw->pt_list[dw->size/2].y,200) )
		return;

	ss_printf("DRAW (%ls) size=%i c=(%f,%f) r=%f\n",
		get_url_str2(&r->h.entry),
		dw->size,
		dw->pt_list[dw->size/2].x,
		dw->pt_list[dw->size/2].y,
		dw->pt_reso[dw->size/2]);
}
*/

int
draw_resource(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	DRAW_WORK * dw)
{
int ret;

/*
printf("resource (%i) %x %i %s\n",
get_tid(),r,r->h.type,n_string(std_cm,get_url_str2(&r->h.entry)));
*/

	if ( r->h.type >= RT_MAX )
		er_panic("draw_resource(1)");
	if ( r->h.type < 0 )
		er_panic("draw_resource(2)");
	if ( resource_table[r->h.type][GBF_DRAW] == 0 )
		er_panic("draw_resource(3)");
	ret = (*resource_table[r->h.type][GBF_DRAW])
		(gf,r,dw);

/*
printf("resrouce (%i)end\n",get_tid());
*/
	return ret;
}



int
get_point_resource(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	GET_POINT_WORK * w)
{
int ret;

	if ( r->h.type >= RT_MAX )
		er_panic("get_point_resource(1)");
	if ( r->h.type < 0 )
		er_panic("get_point_resource(2)");
	if ( resource_table[r->h.type][GBF_GET_POINT] == 0 )
		er_panic("get_point(3)");
/*
ss_printf("gp %ls\n",get_url_str2(&r->h.entry));
*/
	ret = (*resource_table[r->h.type][GBF_GET_POINT])
		(gf,r,w);
/*
ss_printf("gp %ls end\n",get_url_str2(&r->h.entry));
*/
	return ret;
}


int
select_resource(
	RESOURCE * r,
	SELECT_WORK * sw)
{
	if ( r->h.type >= RT_MAX )
		er_panic("select_resource(1)");
	if ( r->h.type < 0 )
		er_panic("select_resource(2)");
	if ( resource_table[r->h.type][GBF_SELECT] == 0 )
		er_panic("select_resource(3)");
	return (*resource_table[r->h.type][GBF_SELECT])
		(r,sw);
}

int
check_resource(
	RESOURCE * r,
	CHECK_WORK * chk)
{
int ret;
	if ( r->h.type >= RT_MAX )
		er_panic("check_resource(1)");
	if ( r->h.type < 0 )
		er_panic("check_resource(2)");
	if ( resource_table[r->h.type][GBF_CHECK] == 0 )
		er_panic("check_resource(3)");
	ret = (*resource_table[r->h.type][GBF_CHECK])
		(r,chk);
	return ret;
}



int
get_point_default(
	GBVIEW_FLAME * gf,
	RESOURCE * r,
	GET_POINT_WORK * p)
{
INDICATE * in;

	in = _insert_indicate(&p->indicate_list,&r->h.entry);
	if ( in->flags&IF_COORDINATE ) {
		in->status = IS_COORDINATE;
		memcpy(in->result,p->pt,sizeof(p->pt));
		in->unit = ll_copy_str(r->h.cu.unit);
	}
	return 0;
}


int
select_default()
{
	return 0;
}

int
check_default(RESOURCE * r,CHECK_WORK * chk)
{
	chk->type[r->h.type] ++;
	if ( chk->resource == r )
		chk->flags |= CWF_RESOURCE;
	return 0;
}

int
close_default(RESOURCE * r)
{
	return 0;
}

int
exit_lock_resource(RESOURCE * r,int data)
{
int ret;
	if ( r->h.type >= RT_MAX )
		er_panic("browse_resource(1)");
	if ( r->h.type < 0 )
		er_panic("browse_resource(2)");
	if ( resource_table[r->h.type][GBF_EXIT_LOCK] == 0 )
		return 0;
	ret = (*resource_table[r->h.type][GBF_EXIT_LOCK])(r,data);
	return ret;
}

int
close_resource(RESOURCE * r)
{
int ret;
	if ( r->h.type >= RT_MAX )
		er_panic("close_resource(1)");
	if ( r->h.type < 0 )
		er_panic("close_resource(2)");
	if ( resource_table[r->h.type][GBF_CLOSE] == 0 )
		return 0;
	ret = (*resource_table[r->h.type][GBF_CLOSE])(r);
	return ret;
}

