/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_CONTAINER_H___
#define VPF_CONTAINER_H___

// list
typedef struct VPFListItem{
	struct VPFListItem *next;
	void *data;
}VPF_LIST_ITEM;

typedef struct VPFList{
	VPF_LIST_ITEM *head;
	VPF_LIST_ITEM *tail;
	void (*data_destructor)(void *data);
}VPF_LIST;

typedef void (*vpf_list_data_destructor_type)(void *);
VPF_LIST *vpf_list_new(void (*data_destructor)(void *));
void vpf_list_push(VPF_LIST *list, void *data);
void vpf_list_delete(VPF_LIST *list);
int vpf_list_size(const VPF_LIST *list);
void vpf_list_invert(VPF_LIST *dest, const VPF_LIST *source);


// binaly map
typedef struct VPFMapItem{
	struct VPFMapItem *left;
	struct VPFMapItem *right;
	void *key;
	void *data;
}VPF_MAP_ITEM;

typedef struct VPFMap{
	VPF_MAP_ITEM *root;
	void (*data_destructor)(void *key, void *data);
	int (*comp)(const void *lhs, const void *rhs);
}VPF_MAP;

typedef void (*vpf_map_data_destructor_type)(void *key,void *data);
typedef int (*vpf_map_comp_type)(const void *lhs, const void *rhs);

VPF_MAP *vpf_map_new(void (*data_destructor)(void *key,void *data), int (*comp)(const void *lhs, const void *rhs));
void vpf_map_push(VPF_MAP *map, void *key, void *data);
void vpf_map_delete(VPF_MAP *map);
VPF_MAP_ITEM *vpf_map_item_new();
void vpf_map_item_delete(VPF_MAP_ITEM *item,  void (*data_destructor)(void *,void*));
void *vpf_map_find(const VPF_MAP *map, const void *key);

#endif
