/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "machine/v_types.h"
#include "v/VButton.h"
#include "VReflector.h"
#include "CClickCheckAttachment.h"

#include <LPopupButton.h>

extern "C" {
#include	"machine/v_types.h"
#include	"memory_debug.h"

char * mac_string(LC_FONT * f, const L_CHAR * _str);
VFONT* _v_set_descriptor_get_font(LC_FONT ** ff,const L_CHAR * descriptor,
			const LC_WRITING_STYLE * ws, int fsize, int *size);
}

VExError
VPopupButton::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	list_num = 0;
	list_lc = 0;
	list_ws = 0;
	
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	LPopupButton *v = new LPopupButton(paneInfo, msg_ValueChanged);
	v->SetMacMenuH(::NewMenu(sts.id, "\p"));
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	info = v;

	sts.min_size.w = 24;
	sts.min_size.h = 20;
	return nmp->add_child_do(this);
}

void
VPopupButton::destroy_do(VObject* nmp)
{
	// radio_group will be automatically deleted
	VButton::destroy_do(nmp);
}

VPopupButton::~VPopupButton()
{
	if ( list_lc )
		delete list_lc;
	if ( list_ws )
		delete list_ws;
}


VExError
VPopupButton::get_status(VObjectStatus *s, int flags) const
{
	VExError err;
	V_OP_START_EX
	
	if ( flags & VSF_VALUE ) {
		s->value = info->GetValue() - 1;
		flags &= ~VSF_VALUE;
	}
	err = initial_VExError(V_ER_NO_ERR,flags,0);
	
	err = merge_VExError_vstatus_type(err,VButton::get_status(s,flags));
	
	V_OP_END
	return err;
};

VExError
VPopupButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);

	flags &= ~VSF_DESC;	// Descriptor of LPopupButton is not used

	if ( flags & VSF_VALUE ) {
		info->SetValue(s->value+1);
		err.subcode1 &= ~VSF_VALUE;
	}

	err = merge_VExError_vstatus_type(err,VButton::set_status(s,flags));

	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

VExError
VPopupButton::set_list(int num, const L_CHAR **list,
		const LC_WRITING_STYLE **ws)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,0,0);
	Str255 name;
	
	// copy data into object
	list_num = num;
	list_lc = new L_CHAR*[num];
	if ( ws )
		list_ws = new const LC_WRITING_STYLE*[num];
	for ( int i = 0 ; i < num ; i++ ) {
		list_lc[i] = list[i] ? ll_copy_str(const_cast<L_CHAR*>(list[i])) : 0;
		if ( ws )
			list_ws[i] = ws[i];
	}

	// set to the popup button
	LPopupButton* pb = (LPopupButton*)info;
	pb->DeleteAllMenuItems();
	for ( int i = 0 ; i < num ; i++ ) {
		LC_FONT *ff = 0;
		int size;
		const LC_WRITING_STYLE *wsi = (ws && ws[i]) ? ws[i] : sts.ws;
		VFONT *vf = wsi ? _v_set_descriptor_get_font(&ff, list[i], 
			wsi, sts.fsize, &size) : 0;
		c2pstrcpy(name, list[i] ? mac_string(ff, list[i]) : "-");
		MenuHandle menuH = pb->GetMacMenuH();
		::MacAppendMenu(menuH, Str_Dummy);
		::SetMenuItemText(menuH, ::CountMenuItems(menuH), name);
		if ( ff )
			::SetMenuFont(menuH, vf->id, size/10);
		pb->SetMenuMinMax();
	}
	pb->SetValue(sts.value+1);
	
	CalcMenuSize(pb->GetMacMenuH());
	short w = GetMenuWidth(pb->GetMacMenuH());
	sts.min_size.w = w + 16;
	sts.min_size.h = 14+sts.fsize/10;

	V_OP_END
	
	VLayout::mark(this);
	return err;
};


VExError
VPopupButton::get_list(int *num, L_CHAR ***list, const LC_WRITING_STYLE ***ws)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,0,0);
	
	*num = list_num;
	*list = (L_CHAR**)d_alloc(sizeof(L_CHAR*)*list_num);
	set_buffer(*list);
	if ( ws ) {
		if ( list_ws == 0 )
			*ws = 0;
		else {
			*ws = (const LC_WRITING_STYLE**)d_alloc(sizeof(LC_WRITING_STYLE*)*list_num);
			set_buffer(*ws);
		}
	}
	for ( int i = 0 ; i < list_num ; i++ ) {
		if ( list_lc[i] ) {
			(*list)[i] = ll_copy_str(const_cast<L_CHAR*>(list_lc[i]));
			set_buffer((*list)[i]);
		}
		else
			(*list)[i] = 0;
		if ( ws && *ws )
			(*ws)[i] = list_ws[i];
	}
	
	V_OP_END
	return err;
}
