/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___M_TASK_H___
#define ___M_TASK_H___

#include	<pthread.h>
#include	<semaphore.h>

#define THREAD_BLOCK_SIZE	2000


#define __M_THREAD_1_H__

#include	"m_thread.h"

#ifndef __M_THREAD_1_END_H__
typedef sem_t _SEM;
#endif

#ifdef DEADLOCK_CHECK
typedef struct _sem {
	struct _sem *	next;
	int		level;
	int		tid;
	sem_t		s;
	char *		lock_file;
	int		lock_line;
	char *		unlock_file;
	int		unlock_line;
} _SEM;

#endif


typedef _SEM *D_SEM;


typedef struct wd_entry {
	struct wd_entry *	next;
	int			fd;
	int			state;
#define WDS_SAME_FD_WAIT	1
#define WDS_POLLING		2
#define WDS_LOCKED		3
#define WDS_CP_LOCKED		4
#define WDS_SIGNAL		5
#define WDS_CP_SIGNAL		6
	int			type;
	HTID			htid;
	int			p_events;
	int			p_revents;
} WD_ENTRY;


/*
typedef struct rw_lock {
	SEM		lock;
	int		read_cnt;
} RW_LOCK;



typedef struct fifo_el {
	struct fifo_el *	next;
} FIFO_EL;

typedef struct fifo {
	SEM			lock;
	int			length;
	struct fifo_el *	head;
	struct fifo_el *	tail;
} FIFO;
*/

typedef int TKEY;
#define GET_TKEY(x)	(x)
HTID get_hard_tid(int);


void * new_block();
void free_block();
void set_alarm_mask(int flags);
void init_thread_block();
void sw_init();

void set_ignore_chld();
void all_signal_mask_posix();
void all_signal_mask(int from,int to);

int _create_task(void (*func)(),int data,int pri);


#define __M_THREAD_2_H__

#include	"m_thread.h"

void throw_signal(int tid,int sig);
int ss_do(void (*func)(void*),void * arg);

int _sem_getvalue(D_SEM s,int * value);


void t_sleep_task(unsigned int,D_SEM,int);
void t_wakeup_task(unsigned int,int);


WD_ENTRY * wait_data_lock(int fd,int type);
#define WDT_READ	1
#define WDT_WRITE	2
#define WDT_CLOSE	4

int wait_data_unlock(WD_ENTRY *);


int
call_main(int argc,char ** argv,int (*main_ptr)(int,char**));
void
u_child_countdown();
int
u_child_countup();


#endif

