/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<signal.h>
#include	"machine/include.h"
#include	"init.h"
#include	"task.h"
#include	"utils.h"

void sigalarm_handler();
void sigpipe_handler();
void sigint_handler(); 
void sigignore();

extern int task_flags;


void
set_ignore_chld()
{
  struct sigaction sa;
  sa.sa_handler = SIG_IGN;
  sa.sa_flags = SA_NOCLDWAIT;
  sigemptyset(&sa.sa_mask);
  sigaction(SIGCHLD, &sa, NULL);
}


void
ignore_chld(int sig)
{
	while (1)  {
		if ( waitpid(-1,NULL,WNOHANG) <= 0 )
			break;
	}
	signal(SIGCHLD,ignore_chld);
}

/*
void
set_ignore_chld()
{
	signal(SIGCHLD,ignore_chld);
}
*/

void
all_signal_mask_posix()
{
	all_signal_mask(1,_NSIG);
}

/*
void
set_ignore_chld()
{
	sigignore(SIGCHLD);
}
*/

void
set_alarm_mask(int flags)
{
	all_signal_mask_posix();
	signal(SIGALRM,sigalarm_handler);
	signal(SIGPIPE,sigpipe_handler);
	signal(SIGINT,sigint_handler);
	task_flags = flags;
//	if ( (flags&INI_THREAD) == INI_DONTWAITCHI )
		set_ignore_chld();
}

