/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
2	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#define U_FILE_LIB

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include	"machine/include.h"
#include	"u_file.h"


typedef struct u_fd_debug {
	char *		file;
	int		line;
} U_FD_DEBUG;


typedef struct u_checksum_type {
	struct u_checksum_type * next;
	int			fd;
	unsigned int		w_checksum;
	U_HISTORY		u_history;
} U_CHECKSUM_TYPE;

int _get_tid();
UFR_TBL * ufr_dispatch;
int open_err_sub_code;
int open_err_main_code;
int u_open_point;

U_FD_DEBUG *	fdd_list;

#define U_CK_HASH_SIZE	103
#define RW_MODE	(O_RDONLY|O_WRONLY|O_RDWR)


U_CHECKSUM_TYPE ** ck_hash_table;


void
new_ck_hash_table()
{
	if ( ck_hash_table )
		return;
	ck_hash_table = malloc(sizeof(U_CHECKSUM_TYPE*)*U_CK_HASH_SIZE);
	memset(ck_hash_table,0,sizeof(U_CHECKSUM_TYPE*)*U_CK_HASH_SIZE);
}

U_CHECKSUM_TYPE**
search_ck(int fd)
{
unsigned int key;
U_CHECKSUM_TYPE ** retp;
	new_ck_hash_table();
	key = ((unsigned int)fd) % U_CK_HASH_SIZE;
	for ( retp = &ck_hash_table[key] ; *retp ; retp = &(*retp)->next )
		if ( (*retp)->fd == fd )
			return retp;
	return 0;
}

void
set_checksum(int fd,void * data,int len)
{
unsigned int sum;
U_CHECKSUM_TYPE * ck, ** ckp;
unsigned int key;
unsigned char * ptr;
 int _len;

	ckp = search_ck(fd);
	if ( ckp == 0 ) {
		ck = malloc(sizeof(*ck));
		memset(ck,0,sizeof(*ck));
		ck->fd = fd;
		new_u_history(&ck->u_history);
		key = ((unsigned int)fd) % U_CK_HASH_SIZE;
		ck->next = ck_hash_table[key];
		ck_hash_table[key] = ck;
	}
	else	ck = *ckp;
	sum = ck->w_checksum;
	_len = len;
	for ( ptr = data ; len > 0 ; len -- , ptr ++ )
		sum += *ptr;
	ck->w_checksum = sum;
	set_u_history(&ck->u_history,_len);
}

int
free_checksum(int fd)
{
U_CHECKSUM_TYPE ** ckp, * ck;
	ckp = search_ck(fd);
	if ( ckp ) {
		ck = *ckp;
		*ckp = ck->next;
		free_u_history(&ck->u_history);
		free(ck);
		return 0;
	}
	return -1;
}

int
get_checksum(int fd,unsigned int * retp,int ** history_p)
{
U_CHECKSUM_TYPE * ck, ** ckp;

	ckp = search_ck(fd);
	if (ckp == 0 ) {
		*retp = 0;
		if ( history_p )
			*history_p = 0;
		return 0;
	}
	ck = *ckp;
	*retp = ck->w_checksum;
	if ( history_p ) {
		*history_p = get_u_history(&ck->u_history);
	}
	return 0;
}

int
u_geteuid()
{
static int uid;
static int flag;
	if ( flag == 0 ) {
		uid = geteuid();
		flag = 1;
	}
	return uid;
}

#define _u_open(fname,flags,...)	\
	xx_u_open(fname,flags,__FILE__,__LINE__,__VA_ARGS__)


int
u_open(char * filename,int flags,int mode)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[3];
UFR_ERR e;
int uid;
int er;
int err;
	tbl = ufr_dispatch;

	if ( tbl && ( (flags&RW_MODE) != O_RDONLY ) ) {
		er=(*tbl->fns.check_own)(&err,&uid,filename);
		if ( er < 0 ) {
			if ( er == -2 ) {
				open_err_main_code = err;
				open_err_sub_code = UFR_E_ERRNO;
				u_open_point = 10;
			}
			else	u_open_point = 1;
			goto dm;
		}
		if ( u_geteuid() == uid ) {
			u_open_point = 2;
			goto dm;
		}
		rq.uid = uid;
		rq.argc = 3;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_CHAR_PTR;
		argv[0].d_char_ptr.d = filename;
		argv[0].d_char_ptr.len = strlen(filename)+1;
		argv[1].type = UFR_T_INT;
		argv[1].d_int.d = flags;
		argv[2].type = UFR_T_INT;
		argv[2].d_int.d = mode;
		rq.ufr_code = UFR_CODE(u_open);
		rq.transaction = 1;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 ) {
			u_open_point = 3;
			return e.r.sys_code;
		}
		else {
			open_err_sub_code = e.ufr_code;
			open_err_main_code = e.r.sys_code;
			errno = e.r.sys_code;
			u_open_point = 4;
			return -1;
		}
	}
	u_open_point = 5;
dm:

	return open(filename,flags,mode);
}


int
u_close(int fd)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[1];
UFR_ERR e;

	tbl = ufr_dispatch;
	if ( tbl && (fd >= 0x10000) ) {
		rq.argc = 1;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		rq.ufr_code = UFR_CODE(u_close);
		rq.transaction = -1;
		e = (*tbl->fns.__ufr_call)(&rq);
		(*tbl->fns.lk_free_checksum)(fd);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}

	free_checksum(fd);
	return close(fd);
}

int
u_write(int fd,void * data,int len)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[2];
UFR_ERR e;
int ret;
	tbl = ufr_dispatch;


	if ( tbl && (fd >= 0x10000)  ) {
		rq.argc = 2;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		argv[1].type = UFR_T_CHAR_PTR;
		argv[1].d_char_ptr.d = data;
		argv[1].d_char_ptr.len = len;
		rq.ufr_code = UFR_CODE(u_write);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 ) {
			(*tbl->fns.lk_set_checksum)(fd,data,e.r.sys_code);
			return e.r.sys_code;
		}
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}

	ret = write(fd,data,len);
	set_checksum(fd,data,ret);
	return ret;
}

int test_offset;

int
u_read(int fd,void * data,int len)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[2];
UFR_ERR e;
	tbl = ufr_dispatch;
	if ( tbl && (fd >= 0x10000)  ) {
		rq.argc = 2;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		argv[1].type = UFR_T_REP_CHAR_PTR;
		argv[1].d_rep_char_ptr.d = data;
		argv[1].d_rep_char_ptr.len = len;
		rq.ufr_code = UFR_CODE(u_read);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}
test_offset = lseek(fd,0,SEEK_CUR);
	return read(fd,data,len);
}

int
u_lseek(int fd,int ofs,int where)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[3];
UFR_ERR e;
	tbl = ufr_dispatch;
	if ( tbl && (fd >= 0x10000)  ) {
		rq.argc = 3;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		argv[1].type = UFR_T_INT;
		argv[1].d_int.d = ofs;
		argv[2].type = UFR_T_INT;
		argv[2].d_int.d = where;
		rq.ufr_code = UFR_CODE(u_lseek);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}

	return lseek(fd,ofs,where);
}

int
u_open64(char * filename,int flags,int mode)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[3];
UFR_ERR e;
int uid;
int err;
	tbl = ufr_dispatch;
	if ( tbl && ( (flags&RW_MODE) != O_RDONLY )  ) {
		if ( (*tbl->fns.check_own)(&err,&uid,filename) < 0 )
			goto dm;
		if ( u_geteuid() == uid )
			goto dm;
		rq.uid = uid;
		rq.argc = 3;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_CHAR_PTR;
		argv[0].d_char_ptr.d = filename;
		argv[0].d_char_ptr.len = strlen(filename)+1;
		argv[1].type = UFR_T_INT;
		argv[1].d_int.d = flags;
		argv[2].type = UFR_T_INT;
		argv[2].d_int.d = mode;
		rq.ufr_code = UFR_CODE(u_open64);
		rq.transaction = 1;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}
dm:

	return _open64(filename,flags,mode);
}

INTEGER64
u_lseek64(int fd,INTEGER64 ofs,int where)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[3];
UFR_ERR e;
	tbl = ufr_dispatch;
	if ( tbl && (fd >= 0x10000)  ) {
		rq.argc = 3;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		argv[1].type = UFR_T_INT64;
		argv[1].d_int64.d = ofs;
		argv[2].type = UFR_T_INT;
		argv[2].d_int.d = where;
		rq.ufr_code = UFR_CODE(u_lseek64);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.d_int64;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}

	return _lseek64(fd,ofs,where);
}

int
u_unlink(char * path)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[1];
UFR_ERR e;
int uid;
int err;
	tbl = ufr_dispatch;
	if ( tbl ) {
		if ( (*tbl->fns.check_own)(&err,&uid,path) < 0 )
			goto dm;
		if ( u_geteuid() == uid )
			goto dm;
		rq.uid = uid;
		rq.argc = 1;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_CHAR_PTR;
		argv[0].d_char_ptr.d = path;
		argv[0].d_char_ptr.len = strlen(path)+1;
		rq.ufr_code = UFR_CODE(u_unlink);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}
dm:

	return unlink(path);
}

int
u_rmdir(char * path)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[1];
UFR_ERR e;
int uid;
int err;
	tbl = ufr_dispatch;
	if ( tbl ) {
		if ( (*tbl->fns.check_own)(&err,&uid,path) < 0 )
			goto dm;
		if ( u_geteuid() == uid )
			goto dm;
		rq.uid = uid;
		rq.argc = 1;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_CHAR_PTR;
		argv[0].d_char_ptr.d = path;
		argv[0].d_char_ptr.len = strlen(path)+1;
		rq.ufr_code = UFR_CODE(u_rmdir);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}
dm:

	return rmdir(path);
}

int
m_mkdir(char * path,int mode)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[2];
UFR_ERR e;
int uid;
int ret;
int err;
	tbl = ufr_dispatch;
	if ( tbl ) {
		if ( (*tbl->fns.check_own)(&err,&uid,path) < 0 )
			goto dm;
		if ( u_geteuid() == uid )
			goto dm;
		rq.uid = uid;
		rq.argc = 2;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_CHAR_PTR;
		argv[0].d_char_ptr.d = path;
		argv[0].d_char_ptr.len = strlen(path)+1;

		argv[1].type = UFR_T_INT;
		argv[1].d_int.d = mode;
		rq.ufr_code = UFR_CODE(u_mkdir);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 )
			return e.r.sys_code;
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}
dm:

	ret = mkdir(path,mode);
	if ( ret < 0 )
		return ret;
	return chmod(path,mode);
}



char *
u_getenv(char * name)
{
	return getenv(name);
}


int
u_checksum(int fd,U_CK_BUF * buf)
{
UFR_TBL * tbl;
UFR_REQ rq;
UFR_ARGS argv[2];
UFR_ERR e;

int ret;
	tbl = ufr_dispatch;
	if ( tbl && (fd >= 0x10000)  ) {
		rq.argc = 2;
		rq.argv = &argv[0];
		argv[0].type = UFR_T_INT;
		argv[0].d_int.d = fd;
		argv[1].type = UFR_T_REP_CHAR_PTR;
		argv[1].d_rep_char_ptr.d = (char*)buf;
		argv[1].d_rep_char_ptr.len = sizeof(*buf);
		rq.ufr_code = UFR_CODE(u_checksum);
		rq.transaction = 0;
		e = (*tbl->fns.__ufr_call)(&rq);
		if ( e.ufr_code >= 0 ) {
			ret = (*tbl->fns.lk_get_checksum)
				(fd,&buf->w_checksum[0],&buf->u_history[0]);
			if ( ret == 0 )
				buf->lev_mask |= 1;
/*
			ret = get_checksum(fd,&buf->w_checksum[1],0);
			if ( ret == 0 )
				buf->lev_mask |= 2;
*/
			return 0;
		}
		else {
			errno = e.r.sys_code;
			return -1;
		}
	}

	
	ret = get_checksum(fd,&buf->w_checksum[1],0);
	buf->u_history[1] = 0;
	buf->u_history[0] = 0;
	if ( ret >= 0 ) {
		buf->w_checksum[0] = 0;
		buf->u_history[0] = 0;
		buf->lev_mask = 2;
	}
	return ret;
}


