/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VBackColorView.h"
#include "machine/v_object.h"

short gdk_state_to_modifiers(gint state);


extern "C" void set_styled_descriptor(
	const L_CHAR * descriptor,
	const LC_WRITING_STYLE * ws,
	int fsize,
	int vert_desc,
	VInfo * info,
	int is_bin);

extern "C" gboolean
button_press_event(GtkWidget *widget, GdkEventButton *event, VBackColorView *obj)
{
	short modkey = gdk_state_to_modifiers(event->state);
	if ( event->button == 1 )
		obj->value_changed(modkey);
	return TRUE;
}

VExError
VBackColorView::create_do(const VObjectStatus* s, int flags, 
			VObject * nmp,void * arg)
{
	info = v_serialized_exec_func(gtk_event_box_new);
	v_serialized_exec_sub(g_object_ref, (void*)info);
	VIA_MS_G_SIGNAL_CONNECT(info, "button_press_event", button_press_event, this);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VBackColorView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, (void*)info);
}

VBackColorView::~VBackColorView()
{
}

VExError
VBackColorView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VBackColorView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_ATTR ) {
		unsigned int r,g,b,a;
		GET_RGB8_32(s->attr,r,g,b,a);
		if ( a == 0x00 ) {
			v_serialized_exec_sub(gtk_widget_modify_bg, info, GTK_STATE_NORMAL, (GdkColor*)0);
		}
		else {
			GdkColor color = {0,r<<8,g<<8,b<<8};
			v_serialized_exec_sub(gtk_widget_modify_bg, info, GTK_STATE_NORMAL, &color);
		}
	}
	if ( flags & VSF_SPACING ) {
		v_serialized_exec_sub(gtk_container_border_width,
			GTK_CONTAINER(info), (unsigned)(s->spacing.w+s->spacing.h)/2); 
		err.subcode1 &= ~VSF_SPACING;
	}
	V_OP_END
	
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

VExError
VBackColorView::add_child_do(VObject* child)
{
	v_serialized_exec_sub(gtk_container_add, GTK_CONTAINER(info),
		child->get_info_this());
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VBackColorView::remove_child_do(VObject* child)
{
	v_serialized_exec_sub(gtk_container_remove, GTK_CONTAINER(info),
			child->get_info_this());
}

void
VBackColorView::child_status_changed(VObject *child, VInfo* cinfo)
{
	// do nothing
}

void
VBackColorView::redraw(VRect *rect) const
{
	// do nothing
}

