/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"v/VProgressBar.h"
#include "machine/v_object.h"


extern "C" void
start_progress_bar_pulse(VInfo *info)
{
	guint timeout;
	timeout = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(info), "timeout"));
	if ( timeout == 0 ) {
		timeout = gtk_timeout_add(100, 
			(GtkFunction)gtk_progress_bar_pulse, info);
		g_object_set_data(G_OBJECT(info), "timeout", (gint*)timeout);
		gtk_progress_bar_pulse(GTK_PROGRESS_BAR(info));
	}
}

extern "C" void
stop_progress_bar_pulse(VInfo *info, gdouble frac)
{
	guint timeout;
	timeout = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(info), "timeout"));
	if ( timeout ) {
		gtk_timeout_remove(timeout);
		g_object_set_data(G_OBJECT(info), "timeout", 0);
	}
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(info), frac);
}


VExError
VProgressBar::create_do(const VObjectStatus* s, int flags, 
			VObject * nmp,void * arg)
{
	info = v_serialized_exec_func(gtk_progress_bar_new);
	v_serialized_exec_sub(gtk_progress_bar_set_pulse_step,
		GTK_PROGRESS_BAR(info), 0.05);
	v_serialized_exec_sub(g_object_ref, info);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VProgressBar::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(stop_progress_bar_pulse, info, 0.0);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VProgressBar::~VProgressBar()
{
}

VExError
VProgressBar::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VProgressBar::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_VALUE ) {
		if ( s->value < 0 )
			v_serialized_exec_sub(start_progress_bar_pulse, info);
		else
			v_serialized_exec_sub(stop_progress_bar_pulse, info, (gdouble)s->value/100);
		err.subcode1 &= ~VSF_VALUE;
	}
	if ( flags & VSF_DESC ) {
		v_serialized_exec_sub(gtk_progress_bar_set_text,
			GTK_PROGRESS_BAR(info), 
			s->descriptor ? (const gchar*)ucd_n_string(s->descriptor) : "");
		err.subcode1 &= ~VSF_DESC;
	}

	V_OP_END
		
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

void
VProgressBar::redraw(VRect* rect) const
{
}
