/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<time.h>
#include	<fcntl.h>
#include	<math.h>
#include	<stdlib.h>
#include	"gbview.h"
#include	"xl.h"
#include	"win_flame.h"


int
cache_image(
	GBVIEW_FLAME * gf,
	WF_ID wfid,
	RESOURCE * c,
	GB_POINT * pt_list,
	REAL1 * pt_reso,
	unsigned long * buf,
	int size,
	GB_RECT * r,
	MAP_HISTORY * mh,
	SURP_SET * surp,
	int method,
	int flags)
{
DRAW_WORK dw;
int i;


	if ( buf ) 
		for ( i = 0 ; i < size ; i ++ )
			buf[i] = C_TRANSPARENT;

	dw.pt_list = pt_list;
	dw.pt_reso = pt_reso,
	dw.pixels = buf;
	dw.size = size;
	dw.rectondisp = r;
	dw.mh = mh;
	dw.method = method;
	dw.surp = *surp;
	dw.data_request = 0;
	dw.flags = flags;
	dw.wfid = wfid;

	if ( wf_active_check_2(gf,dw.wfid) == 0 ) {
		dw.ses = open_session(SEST_OPTIMIZE);
		draw_resource(gf,c,&dw);
		close_session(dw.ses);

		wf_set_data_request(gf,wfid,dw.data_request);
	}
	return dw.flags;
}


