/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"mx.h"

typedef struct gmx_work {
	MX_ENTRY * 	e;
} GMX_WORK;

MX_ENTRY *	mx_list;

void
open_mxread_method(MATRIX_TOKEN * t)
{
MATRIX * m;
MX_ENTRY * e;
GMX_WORK * w;
int i,j;
int sz;
MATRIX_DATA_TYPE * tp;
int err;
MATRIX_PARAM mp;


	m = t->wait_matrix;
	w = m->open_work;
	err = load_matrix_header(m,O_RDONLY,0644);
	if ( err < 0 ) {
		w->e = 0;
		set_matrix_mode(m,MM_ERR);
		return;
	}
	
	memset(&mp,0,sizeof(mp));
//	mp.write_file = matrix_standard_write_file;
	mp.read_file = matrix_standard_read_file;
	mp.close_file = close_matrix_file;

	err = set_matrix_param(m,&mp);

	if ( err < 0 )
		er_panic("setup error");

	for ( e = mx_list ; e ; e = e->next ) {
		if ( e->c.m == m )
			break;
	}
	if ( e == 0 ) {
		e = d_alloc(sizeof(*e));
		memset(e,0,sizeof(*e));
		e->c.m = m;
		e->p.c = &e->c;

		e->c.access_ch = d_alloc(sizeof(int)*m->p.channel_nos);
		e->c.gn_tree_node = GN_NODE;
		e->c.gn_create = GN_ERROR_NORETRY;
		e->c.gn_wait = GN_ERROR_NORETRY;
		
		e->p.data_ix = d_alloc(sizeof(MX_CACHE_PARAM_IX)*m->p.channel_nos);
/*
		e->p.data_ptrs[0] = d_alloc(sizeof(char)*e->c.ds_len);
		e->p.data_ptrs[1] = d_alloc(sizeof(short)*e->c.ds_len);
		e->p.data_ptrs[2] = d_alloc(sizeof(int)*e->c.ds_len);
		e->p.data_ptrs[3] = d_alloc(sizeof(INTEGER64)*e->c.ds_len);
*/
		j = 0;
		for ( i = 0 ; i < m->p.channel_nos ; i ++ ) {
			if ( m->channel_info[i].data_type == 0 ) {
				continue;
			}
			else {
				e->c.access_ch[j] = i;
				tp = m->channel_info[i].data_type;
				if ( tp->parent ) {
					sz = (*tp->parent->get_size)(tp,0);
				}
				else {
					sz = (*tp->get_size)(tp,0);
				}
				switch ( sz ) {
				case 1:
					e->p.data_ix[j].p = 0;
					e->p.data_ix[j].x = i;
					break;
				case 2:
					e->p.data_ix[j].p = 1;
					e->p.data_ix[j].x = i;
					break;
				case 4:
					e->p.data_ix[j].p = 2;
					e->p.data_ix[j].x = i;
					break;
				case 8:
					e->p.data_ix[j].p = 3;
					e->p.data_ix[j].x = i;
					break;
				default:
					e->p.data_ix[j].p = MXC_INVALID;
					e->p.data_ix[j].x = MXC_INVALID;
				}
				j ++;
			}
		}
		e->c.ds_len = j;
		mxc_setup(&e->c);
		
		e->next = mx_list;
		mx_list = e;
	}

	set_matrix_cal(m,MI_FETCH_1_TP,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_PROCESS_ERR_1\"/>\n",
	"<mxLoad target=\"file\"/>\n",
			0));
	set_matrix_cal_equ(m,MI_FETCH_1_MD,MI_FETCH_1_TP);
	set_matrix_cal_equ(m,MI_FETCH_1_BT,MI_FETCH_1_TP);




	w->e = e;
	set_matrix_mode(m,MM_STANBY);
}


MX_ENTRY *
open_mxread(L_CHAR *neturl,L_CHAR * filename,L_CHAR * key)
{
GMX_WORK w;
MATRIX * m;
MX_ENTRY * e;
	memset(&w,0,sizeof(w));
	m = open_matrix_with_search(
			neturl,filename,key,
			open_mxread_method,&w);
	if ( m == 0 )
		return 0;
	wait_matrix_mode(m);
	if ( w.e == 0 ) {
		for ( e = mx_list ; e ; e = e->next )
			if ( e->c.m == m )
				break;
		return e;
	}
	return w.e;
}
