/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_FLAME_H___
#define ___V_GB_FLAME_H___


extern "C" {
#include	"gbgraph.h"
}

#include	"v/VMacro.h"
#include	"v/VButton.h"
#include	"v/VDraw.h"
#include	"v/VgbIndicate.h"
#include	"v/VxlTreeView.h"
#include	"v/VMarshaler.h"

#include	"v/v_switch.h"


#define VSF_FLAME_STYLE			(1<<0)
#define VSF_FLAME_DEFAULT_WS		(1<<1)
#define VSF_FLAME_ZOOM_IN		(1<<2)
#define VSF_FLAME_ZOOM_OUT		(1<<3)
#define VSF_FLAME_GRAB_MODE_BUTTON	(1<<4)
#define VSF_FLAME_ROTATE_MODE_BUTTON	(1<<5)
#define VSF_FLAME_CLICK_MODE_BUTTON	(1<<6)
#define VSF_FLAME_BUTTONS_CONTROL	(1<<7)
#define VSF_FLAME_INDICATE_OBJ		(1<<8)
#define VSF_FLAME_INDICATE_TREE_OBJ	(1<<9)
#define VSF_FLAME_INDICATE_TREE_EYE	(1<<10)
#define VSF_FLAME_INDICATE_TREE_INFO	(1<<11)
#define VSF_FLAME_INDICATE_TREE_BASE	(1<<12)
#define VSF_FLAME_OATTRIBUTE_HANDLER	(1<<13)
#define VSF_FLAME_SELECT_MODE		(1<<14)
#define VSF_FLAME_RELATED_FLAME		(1<<15)
#define VSF_FLAME_FOCUS			(1<<16)

typedef struct _VgbFlameStatus {
	int			style;
#define VGB_STYLE_ON_FLAME_BTN	1
#define VGB_STYLE_EX_FLAME_BTN	2
#define VGB_STYLE_MAX		3


	LC_WRITING_STYLE *	default_ws;

	VButton *		zoom_in;
	VButton *		zoom_out;
	VRadioButton *		grab_mode_button;
	VRadioButton *		rotate_mode_button;
	VRadioButton *		click_mode_button;

	VMarshaler *		buttons_control;

	VgbIndicate *		indicate_obj;
	VxlTreeView *		indicate_tree_obj;

	VImage *		indicate_tree_eye;
	VRect			indicate_tree_eye_elr[2];
	VImage *		indicate_tree_info;
	VRect			indicate_tree_info_elr[2];
	VImage *		indicate_tree_base;
	VRect			indicate_tree_base_elr[5];

	V_CALLBACK		(oattribute_handler);
	void *			oattribute_handler_arg;

	int			select_mode;
#define VGB_MODE_GRAB	1
#define VGB_MODE_ROTATE	2
#define VGB_MODE_CLICK	3

	VObject *		related_flame;
} VgbFlameStatus;

#define VM_MODE		0
#define VM_ZOOM_IN	1
#define VM_ZOOM_OUT	2
#define VM_W3_INFO	3

#define VSF_FLAME_C_STATUS			(1<<0)
#define VSF_FLAME_C_LAYER_NOS			(1<<1)
#define VSF_FLAME_C_FLAME_BASE_RECT		(1<<2)
#define VSF_FLAME_C_FLAME_BASE_CENTER		(1<<3)
#define VSF_FLAME_C_FLAME_BASE_ROTATE		(1<<4)
#define VSF_FLAME_C_FLAME_BASE_RESOLUTION 	(1<<5)
#define VSF_FLAME_C_FLAME_BASE_UNIT		(1<<6)
#define VSF_FLAME_C_FLAME_BASE_DISPLAY_MAP_TYPE	(1<<7)
#define VSF_FLAME_C_CURRENT			(1<<8)
#define VSF_FLAME_C_LAYERS			(1<<9)
#define VSF_FLAME_C_PP_RADIUS			(1<<10)
#define VSF_FLAME_C_TARGET			(1<<11)

typedef struct _VgbFlameLayers {
	struct _VgbFlameLayers *	next;
	WF_ID				id;
	L_CHAR * 			entry_url;
	L_CHAR *			target_url;
	int				flags;
} VgbFlameLayers;

typedef struct _VgbFlameCoordinateStatus {
	int		status;
	int		layer_nos;

	GB_RECT		flame_base_rect;

	GB_POINT	flame_base_center;
	REAL1		flame_base_rotate;
	REAL1		flame_base_resolution;
	L_CHAR *	flame_base_unit;
	int		flame_base_display_map_type;
	WF_ID		current;

	VgbFlameLayers *	layers;

	/* option */

	REAL1		pp_radius;
	L_CHAR *	target;
} VgbFlameCoordinateStatus;


#define VSF_FLAME_R_QUERY_GET		(1<<0)
#define VSF_FLAME_R_QUERY_SET		(1<<1)
#define VSF_FLAME_R_QUERY_REPLACE	(1<<2)
#define VSF_FLAME_R_QUERY_INSERT	(1<<3)
#define VSF_FLAME_R_QUERY_DELETE_BYNO	(1<<4)
#define VSF_FLAME_R_EVENT_HANDLER	(1<<5)
#define VSF_FLAME_R_LOADING_STATUS	(1<<6)

typedef struct _VgbFlameRadarStatus {
	QUERY_THREAD *		query_set;
	QUERY_THREAD *		query_insert;
	QUERY_THREAD *		query_replace;
	int			delete_byno;
	int			result;
	QUERY_THREAD *		result_query;

	void 			(*event_handler)(QUERY_THREAD*,void*);
	void *			eh_user_arg;

	LOADING_STATUS		loading_status;
} VgbFlameRadarStatus;

#define VSF_FLAME_S_FORMAT	(1<<0)
#define VSF_FLAME_S_QUALITY	(1<<1)
#define VSF_FLAME_S_PERIPHERAL	(1<<2)
#define VSF_FLAME_S_PARAMETER	(1<<3)
#define VSF_FLAME_S_AGENT_URL	(1<<4)
#define VSF_FLAME_S_MODE	(1<<5)

typedef struct _VgbFlameSwtichStatus {
	L_CHAR *		format;
	L_CHAR *		quality;
	L_CHAR * 		peripheral;
	L_CHAR *		parameter;
	L_CHAR * 		agent_url;
	int			mode;
} VgbFlameSwitchStatus;

#define VGB_DRAG_MOVE	1
#define VGB_DRAG_ZOOM	2

typedef struct pi_xy {
	int		type;
#define PIT_XY		1
	int *		index_x;
	int *		index_y;
} PI_XY;

typedef struct pi_plane {
	int		type;
#define PIT_PLANE	2
	I_POINT *	index;
} PI_PLANE;

typedef union ptr_index {
	int		type;
	PI_PLANE	p;
	PI_XY		xy;
} PTR_INDEX;

typedef struct move_set {
	int		(*param_func)(struct flame_work *,void **);
	int		(*flame_func)(struct flame_work *);
	int 		(*index_func)(struct flame_work *);
	int		(*cmp_func)(struct flame_work *,void*,void*);
} MOVE_SET;

typedef struct tv_shadow {
	int		flags;
	RESOURCE * 	r;
	VStaticText *	main_text;
	VStaticText *	chi_text;
	VexDraw *	eye;
	VexDraw *	info;
	VexDraw *	base;
	VBackColorView *	main_bc;
	VBackColorView *	chi_bc;
} TV_SHADOW;

typedef struct flame_work {
	class VgbFlameStandard *	this_object;

	VgbFlameStatus	sts;

	TV_SHADOW *			tree_view_data;
	int				tree_view_data_len;
	int				tree_view_data_dir;
	VImage *			tree_view_eye[2];
	VImage *			tree_view_info[2];
	VImage *			tree_view_base[5];

	V_CALLBACK			(oattribute_handler);
	void *				oattribute_handler_arg;

	VgbFlameSwitchStatus sw_sts;
	FLAME_SWITCH	sw;

	int		fw_active;

	VFocusView *	focus;
	VDraw *		im;

	int		seq;
	int		seq_lock;

	int		select_mode_lock;
	char *		select_mode_lock_file;
	int		select_mode_lock_line;

	int		redraw_flag;
	
	int		im_out_off;

	int		mode;

#define GBM_IDLE		0
#define GBM_PRESS_IMAGE		0x01
#define GBM_MOVE_IMAGE		0x02
#define GBM_PRESS_ZOOM_IN	0x04
#define GBM_PRESS_ZOOM_OUT	0x08
#define GBM_PRESS_MODE_BTN	0x10

#define GBM_PRESS		(GBM_PRESS_IMAGE|GBM_MOVE_IMAGE)

	VPoint		press;
	REAL1		press_zoom;
	int		press_time;

	VPoint		instop_pt;
	int		instop_time;
	unsigned	instop_in:1;
	unsigned 	instop_task:1;
	VPoint		instop_update;

	VImage *	ss;
	PTR_INDEX	ix;
	void *		last_shot;
	void *		start_shot;
	MOVE_SET *	ms;

	I_POINT		select_st;
	I_POINT		select_end;
	int		select_flag;

	RADAR_INDICATE	ri;
	
	XL_SEXP *	instop_html;
} FLAME_WORK;


typedef struct vgb_flame_t {
	Q_HEADER	h;
	int		type;
#define VGBFT_INSERT	0
#define VGBFT_CHANGE_BASE 1
#define VGBFT_POINT	2
#define VGBFT_B_CLICK	3
#define VGBFT_INFOLIST	4
	FLAME_WORK *	fw;
	VPoint		pt;
	INFO_LIST *	infolist;
} VGB_FLAME_T;




class VgbFlame : public VMacro
{
  public:
	enum { object_type = VO_GFLM };

	virtual unsigned	get_type() const { return object_type; }

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_flame_status(
				VgbFlameStatus *,
				int flags) const;
	virtual VExError set_flame_status(
				const VgbFlameStatus *,
				int flags);
	
	virtual VExError get_coordinate_status(
				VgbFlameCoordinateStatus *,
				int flags) const;
	virtual VExError set_coordinate_status(
				const VgbFlameCoordinateStatus *,
				int flags);

	virtual VExError get_radar_status(
				VgbFlameRadarStatus *,
				int flags) const;
	virtual VExError set_radar_status(
				VgbFlameRadarStatus *,
				int flags);
	
	virtual VExError get_switch_status(VgbFlameSwitchStatus *,int flags) const;
	virtual VExError set_switch_status(const VgbFlameSwitchStatus *,int flags);
	
	virtual VError	drag(int type,VPoint start,VPoint end);

	virtual VExError create_do_out_of_lock(
		const VObjectStatus *,int flags,VObject * nmp,void * arg);

	// XL gc processing if using XL_SEXP in VObject
	//	defined by each VMacro Object
	virtual	void gc() {}

  protected:

  	virtual ~VgbFlame();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);

};

class VgbFlameStandard : public VgbFlame
{
  public:
	enum { object_type = VO_GFLM };
	virtual unsigned	get_type() const { return object_type; }
		
	static VgbFlameStandard*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbFlameStandard*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbFlameStandard*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual VExError get_flame_status(
				VgbFlameStatus *,
				int flags) const;
	virtual VExError set_flame_status(
				const VgbFlameStatus *,
				int flags);

	virtual VExError get_radar_status(
				VgbFlameRadarStatus *,
				int flags) const;
	virtual VExError set_radar_status(
				VgbFlameRadarStatus *,
				int flags);

	virtual VExError get_switch_status(VgbFlameSwitchStatus *,int flags) const;
	virtual VExError set_switch_status(const VgbFlameSwitchStatus *,int flags);
	

	virtual VExError get_coordinate_status(
				VgbFlameCoordinateStatus *,
				int flags) const;
	virtual VExError set_coordinate_status(
				const VgbFlameCoordinateStatus *,
				int flags);

	virtual VExError create_do_out_of_lock(
		const VObjectStatus *,int flags,VObject * nmp,void * arg);

//	virtual VError	drag(int type,VPoint start,VPoint end);

	virtual void _vfq_event_task_insert(VGB_FLAME_T *);
	virtual void _vfq_event_task_point(VGB_FLAME_T *);
	virtual void _vfq_event_task_change_base(VGB_FLAME_T*);
	virtual void _eye_handler(VObject*);
	virtual void _base_handler(VObject*);
	virtual int _flame_focus_handler(int edit_type,int len,VBackColorView ** bcl);
	virtual void _flame_focus_command_status();
	virtual void _flame_focus_obey_command(int type);

	// XL gc processing if using XL_SEXP in VObject
	//	defined by each VMacro Object
	virtual	void gc();

  protected:

  	virtual ~VgbFlameStandard();
	
	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

	FLAME_WORK	fw;

  private:
	static VObject *internal_new(){
	VgbFlameStandard * ret;
		ret = new VgbFlameStandard();
		return ret;
	}
};

void free_VgbFlameLayers(VgbFlameLayers * l);
void free_VgbFlameCoordinateStatus(struct _VgbFlameCoordinateStatus *,int);

#endif
