/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___VIEWINDEX_H___
#define ___VIEWINDEX_H___

#include	"gbgraph.h"
#include	"v.h"
#include	"gbview.h"

void
wf_rotate_matrix(
	AFFEN2D * inv_a,
	GB_POINT from,
	GB_POINT to,
	int width,
	int height);
void
wf_make_rotate_index(
	I_POINT * index,
	GB_POINT from,
	GB_POINT to,
	int width,
	int height);
void
wf_make_zoom_index(
	int * index_x,
	int * index_y,
	REAL1 zoom,
	int w,
	int h);
int
wf_make_gmatrix_index(
	I_POINT * index,
	GB_POINT from,
	GB_POINT to,
	double radius,
	int width,
	int height);

/* GLOBE UTILS */

GB_POINT
get_globe_position3d(GB_POINT3D p);
int
get_globe_position(GB_POINT * on_g,GB_POINT pt,double radius);
void
get_round_matrix3d_lambda(MATRIX3D rm,double lambda);
void
get_round_matrix3d_phi(MATRIX3D rm,double phi);
void
get_round_matrix3d_cita(MATRIX3D rm,double cita);
void
get_round_matrix3d(MATRIX3D rm,GB_POINT p);
int
get_gmatrix(MATRIX3D rm,
	GB_POINT from,
	GB_POINT to,
	double radius);
int
get_inv_gmatrix(MATRIX3D rm,
	GB_POINT from,
	GB_POINT to,
	double radius);

GB_POINT v2gb_point(I_POINT v);
void
index_move(unsigned long * dest,unsigned long *src,
		I_POINT * index,int w,int h,unsigned long no_data,
		unsigned long dirty_bit);

/* prototype for win_flame.c */

int wf_move(GBVIEW_FLAME * ,I_POINT from,I_POINT to);

void
wf_get_coordinate_info(GBVIEW_FLAME *,L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len);


#endif

