/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <ctype.h>

#include "vpf_std.h"

#include "vpf_file.h"
#include "gm_tileref_aft.h"

void gm_tileref_aft_delete(GM_TILEREF_AFT_RECORD *record){
	free(record);
}

VPF_RECORD_READER_BEGIN(
	gm_tileref_aft_read, 
	GM_TILEREF_AFT_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD(tile_name)
	{
		char *ptr=r->tile_name;
		for(;*ptr;++ptr){
			if(*ptr == '\\'){
				*ptr = '/';
			}
			*ptr = tolower(*ptr);
		}
	}
	VPF_READ_FIELD(fac_id)
VPF_RECORD_READER_END()

GM_TILEREF_AFT_RECORD *vpf_tilelef_get_tile(VPF_TABLE *table, LONG tileid){
VPF_LIST_ITEM *it;
GM_TILEREF_AFT_RECORD *r;

	for(it=table->records->head; it; it=it->next){
		r = (GM_TILEREF_AFT_RECORD*)it->data;
		if(r->id == tileid){
			return r;
		}
	}
	return NULL;
}

